/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.utils.CompactInstanceWrapper;
import org.javarosa.core.model.instance.utils.InstanceTemplateManager;

public class CachingInstanceTemplateManager
implements InstanceTemplateManager {
    private Hashtable<Integer, FormInstance> templateCache = new Hashtable();
    private Vector<Integer> allowedFormTypes;
    private boolean restrictFormTypes;

    public CachingInstanceTemplateManager() {
        this(true);
    }

    public CachingInstanceTemplateManager(boolean bl) {
        this.restrictFormTypes = bl;
        this.allowedFormTypes = new Vector();
    }

    public void clearCache() {
        this.templateCache.clear();
    }

    public void addFormType(int n) {
        if (!this.allowedFormTypes.contains(new Integer(n))) {
            this.allowedFormTypes.addElement(new Integer(n));
        }
    }

    public void resetFormTypes() {
        this.allowedFormTypes.removeAllElements();
    }

    public FormInstance getTemplateInstance(int n) {
        if (this.restrictFormTypes && !this.allowedFormTypes.contains(new Integer(n))) {
            throw new RuntimeException("form ID [" + n + "] is not an allowed form type!");
        }
        FormInstance formInstance = this.templateCache.get(new Integer(n));
        if (formInstance == null) {
            formInstance = CompactInstanceWrapper.loadTemplateInstance(n);
            if (formInstance == null) {
                throw new RuntimeException("no formdef found for form id [" + n + "]");
            }
            this.templateCache.put(new Integer(n), formInstance);
        }
        return formInstance;
    }
}

