/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.StorageManager;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.IDataPayloadVisitor;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ModelReferencePayload
implements IDataPayload {
    int recordId;
    IDataPayload payload;
    String destination = null;
    IInstanceSerializingVisitor serializer;

    public ModelReferencePayload() {
    }

    public ModelReferencePayload(int n) {
        this.recordId = n;
    }

    public void setSerializer(IInstanceSerializingVisitor iInstanceSerializingVisitor) {
        this.serializer = iInstanceSerializingVisitor;
    }

    public Object accept(IDataPayloadVisitor iDataPayloadVisitor) {
        this.memoize();
        return this.payload.accept(iDataPayloadVisitor);
    }

    public long getLength() {
        this.memoize();
        return this.payload.getLength();
    }

    public String getPayloadId() {
        this.memoize();
        return this.payload.getPayloadId();
    }

    public InputStream getPayloadStream() {
        this.memoize();
        return this.payload.getPayloadStream();
    }

    public int getPayloadType() {
        this.memoize();
        return this.payload.getPayloadType();
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.recordId = dataInputStream.readInt();
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.recordId);
    }

    private void memoize() {
        if (this.payload == null) {
            IStorageUtility iStorageUtility = StorageManager.getStorage("FORMDATA");
            try {
                FormInstance formInstance = (FormInstance)iStorageUtility.read(this.recordId);
                this.payload = this.serializer.createSerializedPayload(formInstance);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException("ModelReferencePayload failed to retrieve its model from rms [" + iOException.getMessage() + "]");
            }
        }
    }

    public int getTransportId() {
        return this.recordId;
    }

    public void setDestination(String string) {
        this.destination = string;
    }

    public String getDestination() {
        return this.destination;
    }
}

