/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.javarosa.core.services.locale.Localization;
import org.javarosa.core.util.MathUtils;

public class DateUtils {
    private static final int MONTH_OFFSET = 1;
    public static final int FORMAT_ISO8601 = 1;
    public static final int FORMAT_HUMAN_READABLE_SHORT = 2;
    public static final int FORMAT_HUMAN_READABLE_DAYS_FROM_TODAY = 5;
    public static final int FORMAT_TIMESTAMP_SUFFIX = 7;
    public static final long DAY_IN_MS = 86400000L;

    public static DateFields getFields(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateFields dateFields = new DateFields();
        dateFields.year = calendar.get(1);
        dateFields.month = calendar.get(2) + 1;
        dateFields.day = calendar.get(5);
        dateFields.hour = calendar.get(11);
        dateFields.minute = calendar.get(12);
        dateFields.second = calendar.get(13);
        dateFields.secTicks = calendar.get(14);
        return dateFields;
    }

    public static Date getDate(DateFields dateFields) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, dateFields.year);
        calendar.set(2, dateFields.month - 1);
        calendar.set(5, dateFields.day);
        calendar.set(11, dateFields.hour);
        calendar.set(12, dateFields.minute);
        calendar.set(13, dateFields.second);
        calendar.set(14, dateFields.secTicks);
        return calendar.getTime();
    }

    public static String formatDateTime(Date date, int n) {
        String string;
        if (date == null) {
            return "";
        }
        DateFields dateFields = DateUtils.getFields(date);
        switch (n) {
            case 1: {
                string = "T";
                break;
            }
            case 7: {
                string = "";
                break;
            }
            default: {
                string = " ";
            }
        }
        return DateUtils.formatDate(dateFields, n) + string + DateUtils.formatTime(dateFields, n);
    }

    public static String formatDate(Date date, int n) {
        return date == null ? "" : DateUtils.formatDate(DateUtils.getFields(date), n);
    }

    public static String formatTime(Date date, int n) {
        return date == null ? "" : DateUtils.formatTime(DateUtils.getFields(date), n);
    }

    private static String formatDate(DateFields dateFields, int n) {
        switch (n) {
            case 1: {
                return DateUtils.formatDateISO8601(dateFields);
            }
            case 2: {
                return DateUtils.formatDateColloquial(dateFields);
            }
            case 5: {
                return DateUtils.formatDaysFromToday(dateFields);
            }
            case 7: {
                return DateUtils.formatDateSuffix(dateFields);
            }
        }
        return null;
    }

    private static String formatTime(DateFields dateFields, int n) {
        switch (n) {
            case 1: {
                return DateUtils.formatTimeISO8601(dateFields);
            }
            case 2: {
                return DateUtils.formatTimeColloquial(dateFields);
            }
            case 7: {
                return DateUtils.formatTimeSuffix(dateFields);
            }
        }
        return null;
    }

    private static String formatDateISO8601(DateFields dateFields) {
        return dateFields.year + "-" + DateUtils.intPad(dateFields.month, 2) + "-" + DateUtils.intPad(dateFields.day, 2);
    }

    private static String formatDateColloquial(DateFields dateFields) {
        String string = new Integer(dateFields.year).toString();
        if (string.length() == 4) {
            string = string.substring(2, 4);
        }
        return DateUtils.intPad(dateFields.day, 2) + "/" + DateUtils.intPad(dateFields.month, 2) + "/" + string;
    }

    private static String formatDateSuffix(DateFields dateFields) {
        return dateFields.year + DateUtils.intPad(dateFields.month, 2) + DateUtils.intPad(dateFields.day, 2);
    }

    private static String formatTimeISO8601(DateFields dateFields) {
        return DateUtils.intPad(dateFields.hour, 2) + ":" + DateUtils.intPad(dateFields.minute, 2) + ":" + DateUtils.intPad(dateFields.second, 2) + "." + DateUtils.intPad(dateFields.secTicks, 3);
    }

    private static String formatTimeColloquial(DateFields dateFields) {
        return DateUtils.intPad(dateFields.hour, 2) + ":" + DateUtils.intPad(dateFields.minute, 2);
    }

    private static String formatTimeSuffix(DateFields dateFields) {
        return DateUtils.intPad(dateFields.hour, 2) + DateUtils.intPad(dateFields.minute, 2) + DateUtils.intPad(dateFields.second, 2);
    }

    public static String format(Date date, String string) {
        DateFields dateFields = DateUtils.getFields(date);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (++i >= string.length()) {
                    throw new RuntimeException("date format string ends with %");
                }
                c = string.charAt(i);
                if (c == '%') {
                    stringBuffer.append("%");
                    continue;
                }
                if (c == 'Y') {
                    stringBuffer.append(DateUtils.intPad(dateFields.year, 4));
                    continue;
                }
                if (c == 'y') {
                    stringBuffer.append(DateUtils.intPad(dateFields.year, 4).substring(2));
                    continue;
                }
                if (c == 'm') {
                    stringBuffer.append(DateUtils.intPad(dateFields.month, 2));
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append(dateFields.month);
                    continue;
                }
                if (c == 'b') {
                    String[] stringArray = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
                    stringBuffer.append(stringArray[dateFields.month - 1]);
                    continue;
                }
                if (c == 'd') {
                    stringBuffer.append(DateUtils.intPad(dateFields.day, 2));
                    continue;
                }
                if (c == 'e') {
                    stringBuffer.append(dateFields.day);
                    continue;
                }
                if (c == 'H') {
                    stringBuffer.append(DateUtils.intPad(dateFields.hour, 2));
                    continue;
                }
                if (c == 'h') {
                    stringBuffer.append(dateFields.hour);
                    continue;
                }
                if (c == 'M') {
                    stringBuffer.append(DateUtils.intPad(dateFields.minute, 2));
                    continue;
                }
                if (c == 'S') {
                    stringBuffer.append(DateUtils.intPad(dateFields.second, 2));
                    continue;
                }
                if (c == '3') {
                    stringBuffer.append(DateUtils.intPad(dateFields.secTicks, 3));
                    continue;
                }
                if (c == 'Z' || c == 'A' || c == 'B' || c == 'a') {
                    throw new RuntimeException("unsupported escape in date format string [%" + c + "]");
                }
                throw new RuntimeException("unrecognized escape in date format string [%" + c + "]");
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static Date parseDateTime(String string) {
        DateFields dateFields = new DateFields();
        int n = string.indexOf("T");
        if (n != -1 ? !DateUtils.parseDate(string.substring(0, n), dateFields) || !DateUtils.parseTime(string.substring(n + 1), dateFields) : !DateUtils.parseDate(string, dateFields)) {
            return null;
        }
        return DateUtils.getDate(dateFields);
    }

    public static Date parseDate(String string) {
        DateFields dateFields = new DateFields();
        if (!DateUtils.parseDate(string, dateFields)) {
            return null;
        }
        return DateUtils.getDate(dateFields);
    }

    public static Date parseTime(String string) {
        DateFields dateFields = new DateFields();
        if (!DateUtils.parseTime(string, dateFields)) {
            return null;
        }
        return DateUtils.getDate(dateFields);
    }

    private static boolean parseDate(String string, DateFields dateFields) {
        Vector vector = DateUtils.split(string, "-", false);
        if (vector.size() != 3) {
            return false;
        }
        try {
            dateFields.year = Integer.parseInt((String)vector.elementAt(0));
            dateFields.month = Integer.parseInt((String)vector.elementAt(1));
            dateFields.day = Integer.parseInt((String)vector.elementAt(2));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return dateFields.check();
    }

    private static boolean parseTime(String string, DateFields dateFields) {
        Vector vector = DateUtils.split(string, ":", false);
        if (vector.size() != 2 && vector.size() != 3) {
            return false;
        }
        try {
            dateFields.hour = Integer.parseInt((String)vector.elementAt(0));
            dateFields.minute = Integer.parseInt((String)vector.elementAt(1));
            if (vector.size() == 3) {
                char c;
                int n;
                String string2 = (String)vector.elementAt(2);
                for (n = 0; n < string2.length() && (Character.isDigit(c = string2.charAt(n)) || c == '.'); ++n) {
                }
                string2 = string2.substring(0, n);
                double d = Double.parseDouble(string2);
                dateFields.second = (int)d;
                dateFields.secTicks = (int)(1000.0 * (d - (double)dateFields.second));
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return dateFields.check();
    }

    public static Date getDate(int n, int n2, int n3) {
        DateFields dateFields = new DateFields();
        dateFields.year = n;
        dateFields.month = n2;
        dateFields.day = n3;
        return dateFields.check() ? DateUtils.getDate(dateFields) : null;
    }

    public static Date roundDate(Date date) {
        DateFields dateFields = DateUtils.getFields(date);
        return DateUtils.getDate(dateFields.year, dateFields.month, dateFields.day);
    }

    public static Date today() {
        return DateUtils.roundDate(new Date());
    }

    public static int daysInMonth(int n, int n2) {
        if (n == 3 || n == 5 || n == 8 || n == 10) {
            return 30;
        }
        if (n == 1) {
            return 28 + (DateUtils.isLeap(n2) ? 1 : 0);
        }
        return 31;
    }

    public static boolean isLeap(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    private static String formatDaysFromToday(DateFields dateFields) {
        String string = "";
        Date date = DateUtils.getDate(dateFields);
        int n = DateUtils.daysSinceEpoch(new Date()) - DateUtils.daysSinceEpoch(date);
        if (n == 0) {
            return Localization.get("date.today");
        }
        if (n == 1) {
            return Localization.get("date.yesterday");
        }
        if (n == 2) {
            return Localization.get("date.twoago", new String[]{String.valueOf(n)});
        }
        if (n > 2 && n <= 6) {
            return Localization.get("date.nago", new String[]{String.valueOf(n)});
        }
        if (n == -1) {
            return Localization.get("date.tomorrow");
        }
        if (n < -1 && n >= -6) {
            return Localization.get("date.nfromnow", new String[]{String.valueOf(-n)});
        }
        return DateUtils.formatDate(dateFields, 2);
    }

    public static Date getPastPeriodDate(Date date, String string, String string2, boolean bl, boolean bl2, int n) {
        Date date2 = null;
        if (string.equals("week")) {
            int n2;
            int n3 = -1;
            int n4 = -1;
            int n5 = n2 = bl2 ? 1 : 0;
            if (string2.equals("sun")) {
                n3 = 0;
            } else if (string2.equals("mon")) {
                n3 = 1;
            } else if (string2.equals("tue")) {
                n3 = 2;
            } else if (string2.equals("wed")) {
                n3 = 3;
            } else if (string2.equals("thu")) {
                n3 = 4;
            } else if (string2.equals("fri")) {
                n3 = 5;
            } else if (string2.equals("sat")) {
                n3 = 6;
            }
            if (n3 == -1) {
                throw new RuntimeException();
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            switch (calendar.get(7)) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 2: {
                    n4 = 1;
                    break;
                }
                case 3: {
                    n4 = 2;
                    break;
                }
                case 4: {
                    n4 = 3;
                    break;
                }
                case 5: {
                    n4 = 4;
                    break;
                }
                case 6: {
                    n4 = 5;
                    break;
                }
                case 7: {
                    n4 = 6;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            int n6 = (n4 - n3 + (7 + n2)) % 7 - n2 + 7 * n - (bl ? 0 : 6);
            date2 = new Date(date.getTime() - (long)n6 * 86400000L);
        } else if (!string.equals("month")) {
            throw new IllegalArgumentException();
        }
        return date2;
    }

    public static int getMonthsDifference(Date date, Date date2) {
        Date date3 = new Date(date2.getTime() - date.getTime());
        Date date4 = new Date(0L);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date4);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        calendar.setTime(date3);
        int n3 = calendar.get(1);
        int n4 = calendar.get(2);
        int n5 = (n3 - n) * 12 + (n4 - n2);
        return n5;
    }

    public static int daysSinceEpoch(Date date) {
        return DateUtils.dateDiff(DateUtils.getDate(1970, 1, 1), date);
    }

    public static Date dateAdd(Date date, int n) {
        return DateUtils.roundDate(new Date(DateUtils.roundDate(date).getTime() + 86400000L * (long)n + 43200000L));
    }

    public static int dateDiff(Date date, Date date2) {
        return (int)MathUtils.divLongNotSuck(DateUtils.roundDate(date2).getTime() - DateUtils.roundDate(date).getTime() + 43200000L, 86400000L);
    }

    public static Vector split(String string, String string2, boolean bl) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(string2);
        while (n >= 0) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        vector.addElement(string);
        if (bl) {
            for (int i = 0; i < vector.size(); ++i) {
                if (((String)vector.elementAt(i)).length() != 0) continue;
                vector.removeElementAt(i);
                --i;
            }
        }
        return vector;
    }

    public static String intPad(int n, int n2) {
        String string = String.valueOf(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    private static boolean inRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static String formatDateToTimeStamp(Date date) {
        return DateUtils.formatDateTime(date, 1);
    }

    public static String getShortStringValue(Date date) {
        return DateUtils.formatDate(date, 2);
    }

    public static String getXMLStringValue(Date date) {
        return DateUtils.formatDate(date, 1);
    }

    public static String get24HourTimeFromDate(Date date) {
        return DateUtils.formatTime(date, 2);
    }

    public static Date getDateFromString(String string) {
        return DateUtils.parseDate(string);
    }

    public static Date getDateTimeFromString(String string) {
        return DateUtils.parseDateTime(string);
    }

    public static boolean stringContains(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.indexOf(string2) != -1;
    }

    public static class DateFields {
        public int year = 1970;
        public int month = 1;
        public int day = 1;
        public int hour = 0;
        public int minute = 0;
        public int second = 0;
        public int secTicks = 0;

        public boolean check() {
            return DateUtils.inRange(this.month, 1, 12) && DateUtils.inRange(this.day, 1, DateUtils.daysInMonth(this.month - 1, this.year)) && DateUtils.inRange(this.hour, 0, 23) && DateUtils.inRange(this.minute, 0, 59) && DateUtils.inRange(this.second, 0, 59) && DateUtils.inRange(this.secTicks, 0, 999);
        }
    }
}

