/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services;

import java.util.Date;
import org.javarosa.core.api.ILogger;
import org.javarosa.core.log.FatalException;
import org.javarosa.core.log.WrappedException;
import org.javarosa.core.services.PropertyManager;

public class Logger {
    public static final int MAX_MSG_LENGTH = 2048;
    private static ILogger logger;

    public static void registerLogger(ILogger iLogger) {
        logger = iLogger;
    }

    public static ILogger _() {
        return logger;
    }

    public static void log(String string, String string2) {
        if (Logger.isLoggingEnabled()) {
            Logger.logForce(string, string2);
        }
    }

    protected static void logForce(String string, String string2) {
        System.err.println("logger> " + string + ": " + string2);
        if (string2.length() > 2048) {
            System.err.println("  (message truncated)");
        }
        string2 = string2.substring(0, Math.min(string2.length(), 2048));
        if (logger != null) {
            try {
                logger.log(string, string2, new Date());
            }
            catch (RuntimeException runtimeException) {
                System.err.println("exception when trying to write log message! " + WrappedException.printException(runtimeException));
                logger.panic();
            }
        }
    }

    public static boolean isLoggingEnabled() {
        boolean bl;
        boolean bl2 = false;
        try {
            String string = PropertyManager._().getSingularProperty("logenabled");
            bl = string == null || string.equals("Enabled");
        }
        catch (Exception exception) {
            bl = true;
            bl2 = true;
        }
        if (bl2) {
            Logger.logForce("log-error", "could not read 'logging enabled' flag");
        }
        return bl;
    }

    public static void exception(Exception exception) {
        Logger.exception(null, exception);
    }

    public static void exception(String string, Exception exception) {
        Logger.log("exception", (string != null ? string + ": " : "") + WrappedException.printException(exception));
    }

    public static void die(String string, Exception exception) {
        Logger.exception("unhandled exception at top level", exception);
        exception.printStackTrace();
        final FatalException fatalException = new FatalException("unhandled exception in " + string, exception);
        new Thread(){

            public void run() {
                throw fatalException;
            }
        }.start();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw fatalException;
    }

    public static void crashTest(String string) {
        throw new FatalException(string != null ? string : "shit has hit the fan");
    }

    public static void halt() {
        if (logger != null) {
            logger.halt();
        }
    }
}

