/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.javarosa.core.services.IPropertyManager;
import org.javarosa.core.services.properties.IPropertyRules;
import org.javarosa.core.services.properties.Property;
import org.javarosa.core.services.storage.IStorageUtilityIndexed;
import org.javarosa.core.services.storage.StorageFullException;
import org.javarosa.core.services.storage.StorageManager;

public class PropertyManager
implements IPropertyManager {
    private static IPropertyManager instance;
    public static final String STORAGE_KEY = "PROPERTY";
    private Vector rulesList;
    private IStorageUtilityIndexed properties = (IStorageUtilityIndexed)StorageManager.getStorage("PROPERTY");

    public static void setPropertyManager(IPropertyManager iPropertyManager) {
        instance = iPropertyManager;
    }

    public static void initDefaultPropertyManager() {
        StorageManager.registerStorage(STORAGE_KEY, Property.class);
        PropertyManager.setPropertyManager(new PropertyManager());
    }

    public static IPropertyManager _() {
        if (instance == null) {
            PropertyManager.initDefaultPropertyManager();
        }
        return instance;
    }

    public PropertyManager() {
        this.rulesList = new Vector();
    }

    public String getSingularProperty(String string) {
        Vector vector;
        String string2 = null;
        if ((this.rulesList.size() == 0 || this.checkPropertyAllowed(string)) && (vector = this.getValue(string)) != null && vector.size() == 1) {
            string2 = (String)vector.elementAt(0);
        }
        if (string2 == null) {
            System.out.println("Warning: Singular property request failed for property " + string);
        }
        return string2;
    }

    public Vector getProperty(String string) {
        if (this.rulesList.size() == 0) {
            return this.getValue(string);
        }
        if (this.checkPropertyAllowed(string)) {
            return this.getValue(string);
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string2);
        this.setProperty(string, vector);
    }

    public void setProperty(String string, Vector vector) {
        Vector vector2 = this.getProperty(string);
        if (vector2 != null && this.vectorEquals(vector2, vector)) {
            return;
        }
        if (this.rulesList.size() == 0) {
            this.writeValue(string, vector);
        } else {
            boolean bl = true;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                if (this.checkValueAllowed(string, (String)enumeration.nextElement())) continue;
                bl = false;
            }
            if (bl) {
                this.writeValue(string, vector);
                this.notifyChanges(string);
            } else {
                System.out.println("Property Manager: Unable to write value (" + vector + ") to " + string);
            }
        }
    }

    private boolean vectorEquals(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i).equals(vector2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public Vector getRules() {
        return this.rulesList;
    }

    public void setRules(IPropertyRules iPropertyRules) {
        this.rulesList.removeAllElements();
        this.rulesList.addElement(iPropertyRules);
    }

    public void addRules(IPropertyRules iPropertyRules) {
        if (iPropertyRules != null) {
            this.rulesList.addElement(iPropertyRules);
        }
    }

    public boolean checkPropertyAllowed(String string) {
        if (this.rulesList.size() == 0) {
            return true;
        }
        boolean bl = false;
        Enumeration enumeration = this.rulesList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            IPropertyRules iPropertyRules = (IPropertyRules)enumeration.nextElement();
            if (!iPropertyRules.checkPropertyAllowed(string)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean checkValueAllowed(String string, String string2) {
        if (this.rulesList.size() == 0) {
            return true;
        }
        boolean bl = false;
        Enumeration enumeration = this.rulesList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            IPropertyRules iPropertyRules = (IPropertyRules)enumeration.nextElement();
            if (!iPropertyRules.checkPropertyAllowed(string) || !iPropertyRules.checkValueAllowed(string, string2)) continue;
            bl = true;
        }
        return bl;
    }

    private void notifyChanges(String string) {
        if (this.rulesList.size() == 0) {
            return;
        }
        boolean bl = false;
        Enumeration enumeration = this.rulesList.elements();
        while (enumeration.hasMoreElements() && !bl) {
            IPropertyRules iPropertyRules = (IPropertyRules)enumeration.nextElement();
            if (!iPropertyRules.checkPropertyAllowed(string)) continue;
            iPropertyRules.handlePropertyChanges(string);
        }
    }

    public Vector getValue(String string) {
        try {
            Property property = (Property)this.properties.getRecordForValue("NAME", string);
            return property.value;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public void writeValue(String string, Vector vector) {
        Property property = new Property();
        property.name = string;
        property.value = vector;
        Vector vector2 = this.properties.getIDsForValue("NAME", string);
        if (vector2.size() == 1) {
            property.setID((Integer)vector2.elementAt(0));
        }
        try {
            this.properties.write(property);
        }
        catch (StorageFullException storageFullException) {
            throw new RuntimeException("uh-oh, storage full [properties]");
        }
    }
}

