/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services;

import org.javarosa.core.util.PrefixTree;
import org.javarosa.core.util.externalizable.CannotCreateObjectException;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class PrototypeManager {
    private static PrefixTree prototypes;

    public static void registerPrototype(String string) {
        PrototypeManager.getPrototypes().addString(string);
        try {
            PrototypeFactory.getInstance(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CannotCreateObjectException(string + ": not found");
        }
    }

    public static void registerPrototypes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            PrototypeManager.registerPrototype(stringArray[i]);
        }
    }

    public static PrefixTree getPrototypes() {
        if (prototypes == null) {
            prototypes = new PrefixTree();
        }
        return prototypes;
    }
}

