/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.util.Hashtable;
import org.javarosa.core.reference.ReferenceDataSource;
import org.javarosa.core.services.locale.LocaleTextException;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.locale.ResourceFileDataSource;

public class Localization {
    private static Localizer globalLocalizer;

    public static String get(String string) {
        return Localization.get(string, new String[0]);
    }

    public static String get(String string, String[] stringArray) {
        Localization.checkRep();
        return globalLocalizer.getText(string, stringArray);
    }

    public static String get(String string, Hashtable hashtable) {
        Localization.checkRep();
        return globalLocalizer.getText(string, hashtable);
    }

    public static void registerLanguageFile(String string, String string2) {
        Localization.init();
        if (!globalLocalizer.hasLocale(string)) {
            globalLocalizer.addAvailableLocale(string);
        }
        globalLocalizer.registerLocaleResource(string, new ResourceFileDataSource(string2));
        if (globalLocalizer.getDefaultLocale() == null) {
            globalLocalizer.setDefaultLocale(string);
        }
    }

    public static void registerLanguageReference(String string, String string2) {
        Localization.init();
        if (!globalLocalizer.hasLocale(string)) {
            globalLocalizer.addAvailableLocale(string);
        }
        globalLocalizer.registerLocaleResource(string, new ReferenceDataSource(string2));
        if (globalLocalizer.getDefaultLocale() == null) {
            globalLocalizer.setDefaultLocale(string);
        }
    }

    public static Localizer getGlobalLocalizerAdvanced() {
        Localization.init();
        return globalLocalizer;
    }

    public static void setLocale(String string) {
        Localization.checkRep();
        globalLocalizer.setLocale(string);
    }

    public static void setDefaultLocale(String string) {
        Localization.checkRep();
        globalLocalizer.setDefaultLocale(string);
    }

    private static void init() {
        if (globalLocalizer == null) {
            globalLocalizer = new Localizer(true, true);
        }
    }

    private static void checkRep() {
        Localization.init();
        if (globalLocalizer.getAvailableLocales().length == 0) {
            throw new LocaleTextException("There are no locales defined for the application. Please make sure to register locale text using the Locale.register() method");
        }
    }
}

