/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.util.NoLocalizedTextException;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.UnregisteredLocaleException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class Localizer
implements Externalizable {
    private Vector locales;
    private OrderedHashtable localeResources = new OrderedHashtable();
    private OrderedHashtable currentLocaleData = new OrderedHashtable();
    private String defaultLocale = null;
    private String currentLocale = null;
    private boolean fallbackDefaultLocale;
    private boolean fallbackDefaultForm;
    private Vector observers;

    public Localizer() {
        this(false, false);
    }

    public Localizer(boolean bl, boolean bl2) {
        this.locales = new Vector();
        this.observers = new Vector();
        this.fallbackDefaultLocale = bl;
        this.fallbackDefaultForm = bl2;
    }

    public boolean equals(Object object) {
        if (object instanceof Localizer) {
            Localizer localizer = (Localizer)object;
            return ExtUtil.equals(this.locales, this.locales) && ExtUtil.equals(this.localeResources, localizer.localeResources) && ExtUtil.equals(this.defaultLocale, localizer.defaultLocale) && ExtUtil.equals(this.currentLocale, localizer.currentLocale) && this.fallbackDefaultLocale == localizer.fallbackDefaultLocale && this.fallbackDefaultForm == localizer.fallbackDefaultForm;
        }
        return false;
    }

    public boolean getFallbackLocale() {
        return this.fallbackDefaultLocale;
    }

    public boolean getFallbackForm() {
        return this.fallbackDefaultForm;
    }

    public boolean addAvailableLocale(String string) {
        if (this.hasLocale(string)) {
            return false;
        }
        this.locales.addElement(string);
        this.localeResources.put(string, new Vector());
        return true;
    }

    public String[] getAvailableLocales() {
        Object[] objectArray = new String[this.locales.size()];
        this.locales.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasLocale(String string) {
        return string == null ? false : this.locales.contains(string);
    }

    public String getNextLocale() {
        return this.currentLocale == null ? this.defaultLocale : (String)this.locales.elementAt((this.locales.indexOf(this.currentLocale) + 1) % this.locales.size());
    }

    public String getLocale() {
        return this.currentLocale;
    }

    public void setLocale(String string) {
        if (!this.hasLocale(string)) {
            throw new UnregisteredLocaleException("Attempted to set to a locale that is not defined. Attempted Locale: " + string);
        }
        if (!string.equals(this.currentLocale)) {
            this.currentLocale = string;
        }
        this.loadCurrentLocaleResources();
        this.alertLocalizables();
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String string) {
        if (string != null && !this.hasLocale(string)) {
            throw new UnregisteredLocaleException("Attempted to set default to a locale that is not defined");
        }
        this.defaultLocale = string;
    }

    public void setToDefault() {
        if (this.defaultLocale == null) {
            throw new IllegalStateException("Attempted to set to default locale when default locale not set");
        }
        this.setLocale(this.defaultLocale);
    }

    private void loadCurrentLocaleResources() {
        this.currentLocaleData = this.getLocaleData(this.currentLocale);
    }

    private void loadTable(OrderedHashtable orderedHashtable, OrderedHashtable orderedHashtable2) {
        Enumeration enumeration = orderedHashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            orderedHashtable.put(string, (String)orderedHashtable2.get(string));
        }
    }

    public void registerLocaleResource(String string, LocaleDataSource localeDataSource) {
        if (string == null) {
            throw new NullPointerException("Attempt to register a data source to a null locale in the localizer");
        }
        if (localeDataSource == null) {
            throw new NullPointerException("Attempt to register a null data source in the localizer");
        }
        Vector vector = new Vector();
        if (this.localeResources.containsKey(string)) {
            vector = (Vector)this.localeResources.get(string);
        }
        vector.addElement(localeDataSource);
        this.localeResources.put(string, vector);
        if (string.equals(this.currentLocale)) {
            this.loadCurrentLocaleResources();
        }
    }

    public OrderedHashtable getLocaleData(String string) {
        Vector vector;
        if (string == null || !this.locales.contains(string)) {
            return null;
        }
        OrderedHashtable orderedHashtable = new OrderedHashtable();
        OrderedHashtable orderedHashtable2 = new OrderedHashtable();
        if (this.fallbackDefaultLocale && this.defaultLocale != null) {
            vector = (Vector)this.localeResources.get(this.defaultLocale);
            for (int i = 0; i < vector.size(); ++i) {
                this.loadTable(orderedHashtable2, ((LocaleDataSource)vector.elementAt(i)).getLocalizedText());
            }
            Enumeration enumeration = orderedHashtable2.keys();
            while (enumeration.hasMoreElements()) {
                orderedHashtable.put(enumeration.nextElement(), Boolean.TRUE);
            }
        }
        vector = (Vector)this.localeResources.get(string);
        for (int i = 0; i < vector.size(); ++i) {
            this.loadTable(orderedHashtable2, ((LocaleDataSource)vector.elementAt(i)).getLocalizedText());
        }
        if (this.fallbackDefaultLocale && this.defaultLocale != null) {
            String string2 = "";
            int n = 0;
            Enumeration enumeration = orderedHashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (orderedHashtable.containsKey(string3)) continue;
                string2 = string2 + string3 + ",";
                ++n;
            }
            if (n > 0) {
                throw new NoLocalizedTextException("Error loading locale " + string + ". There were " + n + " keys which were contained in this locale, but were not " + "properly registered in the default Locale. Any keys which are added to a locale should always " + "be added to the default locale to ensure appropriate functioning.\n" + "The missing translations were for the keys: " + string2, string2, this.defaultLocale);
            }
        }
        return orderedHashtable2;
    }

    public OrderedHashtable getLocaleMap(String string) {
        OrderedHashtable orderedHashtable = this.getLocaleData(string);
        if (orderedHashtable == null) {
            throw new UnregisteredLocaleException("Attempted to access an undefined locale.");
        }
        return orderedHashtable;
    }

    public boolean hasMapping(String string, String string2) {
        if (string == null || !this.locales.contains(string)) {
            throw new UnregisteredLocaleException("Attempted to access an undefined locale (" + string + ") while checking for a mapping for  " + string2);
        }
        Vector vector = (Vector)this.localeResources.get(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LocaleDataSource localeDataSource = (LocaleDataSource)enumeration.nextElement();
            if (!localeDataSource.getLocalizedText().containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean destroyLocale(String string) {
        if (string.equals(this.currentLocale)) {
            throw new IllegalArgumentException("Attempted to destroy the current locale");
        }
        boolean bl = this.hasLocale(string);
        this.locales.removeElement(string);
        this.localeResources.remove(string);
        if (string.equals(this.defaultLocale)) {
            this.defaultLocale = null;
        }
        return bl;
    }

    public String getText(String string) {
        return this.getText(string, this.currentLocale);
    }

    public String getText(String string, String[] stringArray) {
        String string2 = this.getText(string, this.currentLocale);
        if (string2 == null) {
            throw new NoLocalizedTextException("The Localizer could not find a definition for ID: " + string + " in the '" + this.currentLocale + "' locale.", string, this.currentLocale);
        }
        string2 = Localizer.processArguments(string2, stringArray);
        return string2;
    }

    public String getText(String string, Hashtable hashtable) {
        String string2 = this.getText(string, this.currentLocale);
        if (string2 == null) {
            throw new NoLocalizedTextException("The Localizer could not find a definition for ID: " + string + " in the '" + this.currentLocale + "' locale.", string, this.currentLocale);
        }
        string2 = Localizer.processArguments(string2, hashtable);
        return string2;
    }

    public String getLocalizedText(String string) {
        String string2 = this.getText(string);
        if (string2 == null) {
            throw new NoLocalizedTextException("Can't find localized text for current locale! text id: [" + string + "] locale: [" + this.currentLocale + "]", string, this.currentLocale);
        }
        return string2;
    }

    public String getText(String string, String string2) {
        String string3 = this.getRawText(string2, string);
        if (string3 == null && this.fallbackDefaultForm && string.indexOf(";") != -1) {
            string3 = this.getRawText(string2, string.substring(0, string.indexOf(";")));
        }
        if (string3 == null && this.fallbackDefaultLocale && !string2.equals(this.defaultLocale) && this.defaultLocale != null) {
            string3 = this.getText(string, this.defaultLocale);
        }
        return string3;
    }

    public String getRawText(String string, String string2) {
        if (string == null) {
            throw new UnregisteredLocaleException("Null locale when attempting to fetch text id: " + string2);
        }
        if (string.equals(this.currentLocale)) {
            return (String)this.currentLocaleData.get(string2);
        }
        return (String)this.getLocaleMap(string).get(string2);
    }

    public void registerLocalizable(Localizable localizable) {
        if (!this.observers.contains(localizable)) {
            this.observers.addElement(localizable);
            if (this.currentLocale != null) {
                localizable.localeChanged(this.currentLocale, this);
            }
        }
    }

    public void unregisterLocalizable(Localizable localizable) {
        this.observers.removeElement(localizable);
    }

    public void unregisterAll() {
        this.observers.removeAllElements();
    }

    private void alertLocalizables() {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((Localizable)enumeration.nextElement()).localeChanged(this.currentLocale, this);
        }
    }

    private static String arg(String string) {
        return "${" + string + "}";
    }

    public static Vector getArgs(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf("${");
        while (n != -1) {
            int n2 = string.indexOf("}", n);
            if (n2 == -1) {
                System.err.println("Warning: unterminated ${...} arg");
                break;
            }
            String string2 = string.substring(n + 2, n2);
            if (!vector.contains(string2)) {
                vector.addElement(string2);
            }
            n = string.indexOf("${", n2 + 1);
        }
        return vector;
    }

    public static String processArguments(String string, Hashtable hashtable) {
        int n = string.indexOf("${");
        while (n != -1) {
            int n2 = string.indexOf("}", n);
            if (n2 == -1) {
                System.err.println("Warning: unterminated ${...} arg");
                break;
            }
            String string2 = string.substring(n + 2, n2);
            String string3 = (String)hashtable.get(string2);
            if (string3 != null) {
                string = string.substring(0, n) + string3 + string.substring(n2 + 1);
                n2 = n + string3.length() - 1;
            }
            n = string.indexOf("${", n2 + 1);
        }
        return string;
    }

    public static String processArguments(String string, String[] stringArray) {
        String string2 = string;
        int n = 0;
        while (string2.indexOf("${") != -1 && stringArray.length > n) {
            String string3 = Localizer.extractValue(string, stringArray);
            if (string3 == null) {
                string3 = stringArray[n];
                ++n;
            }
            string2 = Localizer.replaceFirstValue(string2, string3);
        }
        return string2;
    }

    public static String clearArguments(String string) {
        Vector vector = Localizer.getArgs(string);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "";
        }
        return Localizer.processArguments(string, stringArray);
    }

    private static String extractValue(String string, String[] stringArray) {
        return null;
    }

    private static String replaceFirstValue(String string, String string2) {
        int n = string.indexOf("${");
        int n2 = string.indexOf("}");
        return string.substring(0, n) + string2 + string.substring(n2 + 1, string.length());
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.fallbackDefaultLocale = ExtUtil.readBool(dataInputStream);
        this.fallbackDefaultForm = ExtUtil.readBool(dataInputStream);
        this.localeResources = (OrderedHashtable)ExtUtil.read(dataInputStream, new ExtWrapMap(String.class, (ExternalizableWrapper)new ExtWrapListPoly(), true), prototypeFactory);
        this.locales = (Vector)ExtUtil.read(dataInputStream, new ExtWrapList(String.class));
        this.setDefaultLocale((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        String string = (String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory);
        if (string != null) {
            this.setLocale(string);
        }
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeBool(dataOutputStream, this.fallbackDefaultLocale);
        ExtUtil.writeBool(dataOutputStream, this.fallbackDefaultForm);
        ExtUtil.write(dataOutputStream, new ExtWrapMap(this.localeResources, (ExternalizableWrapper)new ExtWrapListPoly()));
        ExtUtil.write(dataOutputStream, new ExtWrapList(this.locales));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.defaultLocale));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.currentLocale));
    }
}

