/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class TableLocaleSource
implements LocaleDataSource {
    private OrderedHashtable localeData;

    public TableLocaleSource() {
        this.localeData = new OrderedHashtable();
    }

    public TableLocaleSource(OrderedHashtable orderedHashtable) {
        this.localeData = orderedHashtable;
    }

    public void setLocaleMapping(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null textID when attempting to register " + string2 + " in locale table");
        }
        if (string2 == null) {
            this.localeData.remove(string);
        } else {
            this.localeData.put(string, string2);
        }
    }

    public boolean hasMapping(String string) {
        return string == null ? false : this.localeData.get(string) != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableLocaleSource)) {
            return false;
        }
        TableLocaleSource tableLocaleSource = (TableLocaleSource)object;
        return ExtUtil.equals(this.localeData, tableLocaleSource.localeData);
    }

    public OrderedHashtable getLocalizedText() {
        return this.localeData;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.localeData = (OrderedHashtable)ExtUtil.read(dataInputStream, new ExtWrapMap(String.class, String.class, true), prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, new ExtWrapMap(this.localeData));
    }
}

