/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapIntEncoding;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapIntEncodingSmall
extends ExtWrapIntEncoding {
    public static final int DEFAULT_BIAS = 1;
    public int bias;

    public ExtWrapIntEncodingSmall(long l) {
        this(l, 1);
    }

    public ExtWrapIntEncodingSmall(long l, int n) {
        this.val = new Long(l);
        this.bias = n;
    }

    public ExtWrapIntEncodingSmall() {
        this(null, 1);
    }

    public ExtWrapIntEncodingSmall(Object object, int n) {
        this.bias = n;
    }

    public ExternalizableWrapper clone(Object object) {
        return new ExtWrapIntEncodingSmall(ExtUtil.toLong(object), this.bias);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException {
        int n = dataInputStream.readByte();
        long l = n == -1 ? (long)dataInputStream.readInt() : (long)((n < 0 ? n + 256 : n) - this.bias);
        this.val = new Long(l);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        int n = ExtUtil.toInt((Long)this.val);
        if (n >= -this.bias && n < 255 - this.bias) {
            dataOutputStream.writeByte((byte)((n += this.bias) >= 128 ? n - 256 : n));
        } else {
            dataOutputStream.writeByte(255);
            dataOutputStream.writeInt(n);
        }
    }

    public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException {
        this.bias = dataInputStream.readUnsignedByte();
    }

    public void metaWriteExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte((byte)this.bias);
    }
}

