/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapList
extends ExternalizableWrapper {
    public ExternalizableWrapper type;

    public ExtWrapList(Vector vector) {
        this(vector, null);
    }

    public ExtWrapList(Vector vector, ExternalizableWrapper externalizableWrapper) {
        if (vector == null) {
            throw new NullPointerException();
        }
        this.val = vector;
        this.type = externalizableWrapper;
    }

    public ExtWrapList() {
    }

    public ExtWrapList(Class clazz) {
        this.type = new ExtWrapBase(clazz);
    }

    public ExtWrapList(ExternalizableWrapper externalizableWrapper) {
        if (externalizableWrapper == null) {
            throw new NullPointerException();
        }
        this.type = externalizableWrapper;
    }

    public ExternalizableWrapper clone(Object object) {
        return new ExtWrapList((Vector)object, this.type);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        Vector<Object> vector = new Vector<Object>(0);
        long l = ExtUtil.readNumeric(dataInputStream);
        int n = 0;
        while ((long)n < l) {
            vector.addElement(ExtUtil.read(dataInputStream, this.type, prototypeFactory));
            ++n;
        }
        this.val = vector;
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        Vector vector = (Vector)this.val;
        ExtUtil.writeNumeric(dataOutputStream, vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            ExtUtil.write(dataOutputStream, this.type == null ? vector.elementAt(i) : this.type.clone(vector.elementAt(i)));
        }
    }

    public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.type = ExtWrapTagged.readTag(dataInputStream, prototypeFactory);
    }

    public void metaWriteExternal(DataOutputStream dataOutputStream) throws IOException {
        Vector vector = (Vector)this.val;
        Object object = this.type == null ? (vector.size() == 0 ? new Object() : vector.elementAt(0)) : this.type;
        ExtWrapTagged.writeTag(dataOutputStream, object);
    }
}

