/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javarosa.core.util.externalizable.CannotCreateObjectException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapIntEncodingSmall;
import org.javarosa.core.util.externalizable.ExtWrapIntEncodingUniform;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapMapPoly;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapTagged
extends ExternalizableWrapper {
    public static final byte[] WRAPPER_TAG = new byte[]{-1, -1, -1, -1};
    public static Hashtable WRAPPER_CODES = new Hashtable();

    public ExtWrapTagged(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof ExtWrapTagged) {
            throw new IllegalArgumentException("Wrapping tagged with tagged is redundant");
        }
        this.val = object;
    }

    public ExtWrapTagged() {
    }

    public ExternalizableWrapper clone(Object object) {
        return new ExtWrapTagged(object);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        ExternalizableWrapper externalizableWrapper = ExtWrapTagged.readTag(dataInputStream, prototypeFactory);
        this.val = ExtUtil.read(dataInputStream, externalizableWrapper, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtWrapTagged.writeTag(dataOutputStream, this.val);
        ExtUtil.write(dataOutputStream, this.val);
    }

    public static ExternalizableWrapper readTag(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray, 0, byArray.length);
        if (PrototypeFactory.compareHash(byArray, WRAPPER_TAG)) {
            int n = ExtUtil.readInt(dataInputStream);
            ExternalizableWrapper externalizableWrapper = null;
            Enumeration enumeration = WRAPPER_CODES.keys();
            while (enumeration.hasMoreElements()) {
                Class clazz = (Class)enumeration.nextElement();
                if ((Integer)WRAPPER_CODES.get(clazz) != n) continue;
                try {
                    externalizableWrapper = (ExternalizableWrapper)PrototypeFactory.getInstance(clazz);
                }
                catch (CannotCreateObjectException cannotCreateObjectException) {
                    throw new CannotCreateObjectException("Serious problem: cannot create built-in ExternalizableWrapper [" + clazz.getName() + "]");
                }
            }
            if (externalizableWrapper == null) {
                throw new DeserializationException("Unrecognized ExternalizableWrapper type [" + n + "]");
            }
            externalizableWrapper.metaReadExternal(dataInputStream, prototypeFactory);
            return externalizableWrapper;
        }
        Class clazz = prototypeFactory.getClass(byArray);
        if (clazz == null) {
            throw new DeserializationException("No datatype registered to serialization code " + ExtUtil.printBytes(byArray));
        }
        return new ExtWrapBase(clazz);
    }

    public static void writeTag(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object instanceof ExternalizableWrapper && !(object instanceof ExtWrapBase)) {
            dataOutputStream.write(WRAPPER_TAG, 0, 4);
            ExtUtil.writeNumeric(dataOutputStream, ((Integer)WRAPPER_CODES.get(object.getClass())).intValue());
            ((ExternalizableWrapper)object).metaWriteExternal(dataOutputStream);
        } else {
            Object object2;
            Class clazz = null;
            if (object instanceof ExtWrapBase) {
                object2 = (ExtWrapBase)object;
                if (((ExtWrapBase)object2).val != null) {
                    object = ((ExtWrapBase)object2).val;
                } else {
                    clazz = ((ExtWrapBase)object2).type;
                }
            }
            if (clazz == null) {
                clazz = object.getClass();
            }
            object2 = PrototypeFactory.getClassHash(clazz);
            dataOutputStream.write((byte[])object2, 0, ((Object)object2).length);
        }
    }

    public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) {
        throw new RuntimeException("Tagged wrapper should never be tagged");
    }

    public void metaWriteExternal(DataOutputStream dataOutputStream) {
        throw new RuntimeException("Tagged wrapper should never be tagged");
    }

    static {
        WRAPPER_CODES.put(ExtWrapNullable.class, new Integer(0));
        WRAPPER_CODES.put(ExtWrapList.class, new Integer(32));
        WRAPPER_CODES.put(ExtWrapListPoly.class, new Integer(33));
        WRAPPER_CODES.put(ExtWrapMap.class, new Integer(34));
        WRAPPER_CODES.put(ExtWrapMapPoly.class, new Integer(35));
        WRAPPER_CODES.put(ExtWrapIntEncodingUniform.class, new Integer(64));
        WRAPPER_CODES.put(ExtWrapIntEncodingSmall.class, new Integer(65));
    }
}

