/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.form.api;

import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormIndex;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.services.Logger;
import org.javarosa.core.util.NoLocalizedTextException;
import org.javarosa.core.util.UnregisteredLocaleException;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.form.api.FormEntryCaption;
import org.javarosa.formmanager.view.IQuestionWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEntryPrompt
extends FormEntryCaption {
    TreeElement mTreeElement;
    boolean dynamicChoicesPopulated = false;

    protected FormEntryPrompt() {
    }

    public FormEntryPrompt(FormDef formDef, FormIndex formIndex) {
        super(formDef, formIndex);
        if (!(this.element instanceof QuestionDef)) {
            throw new IllegalArgumentException("FormEntryPrompt can only be created for QuestionDef elements");
        }
        this.mTreeElement = formDef.getInstance().resolveReference(formIndex.getReference());
    }

    public int getControlType() {
        return this.getQuestion().getControlType();
    }

    public int getDataType() {
        return this.mTreeElement.dataType;
    }

    public String getPromptAttributes() {
        return null;
    }

    public IAnswerData getAnswerValue() {
        QuestionDef questionDef = this.getQuestion();
        ItemsetBinding itemsetBinding = questionDef.getDynamicChoices();
        if (itemsetBinding != null) {
            if (itemsetBinding.valueRef != null) {
                Externalizable externalizable;
                int n;
                Object object;
                Vector<Selection> vector;
                Vector<SelectChoice> vector2 = this.getSelectChoices();
                Vector<String> vector3 = new Vector<String>();
                if (itemsetBinding.copyMode) {
                    vector = itemsetBinding.getDestRef().contextualize(this.mTreeElement.getRef());
                    object = this.form.getInstance().expandReference((TreeReference)((Object)vector));
                    for (n = 0; n < ((Vector)object).size(); ++n) {
                        externalizable = this.form.getInstance().resolveReference((TreeReference)((Vector)object).elementAt(n));
                        String string = itemsetBinding.getRelativeValue().evalReadable(this.form.getInstance(), new EvaluationContext(this.form.exprEvalContext, externalizable.getRef()));
                        vector3.addElement(string);
                    }
                } else {
                    vector = new Vector();
                    object = this.mTreeElement.getValue();
                    if (object instanceof SelectMultiData) {
                        vector = (Vector)object.getValue();
                    } else if (object instanceof SelectOneData) {
                        vector = new Vector<Selection>();
                        vector.addElement((Selection)object.getValue());
                    }
                    for (n = 0; n < vector.size(); ++n) {
                        vector3.addElement(((Selection)vector.elementAt((int)n)).xmlValue);
                    }
                }
                vector = new Vector();
                for (int i = 0; i < vector3.size(); ++i) {
                    String string = (String)vector3.elementAt(i);
                    externalizable = null;
                    for (int j = 0; j < vector2.size(); ++j) {
                        SelectChoice selectChoice = vector2.elementAt(j);
                        if (!string.equals(selectChoice.getValue())) continue;
                        externalizable = selectChoice;
                        break;
                    }
                    vector.addElement(((SelectChoice)externalizable).selection());
                }
                if (vector.size() == 0) {
                    return null;
                }
                if (questionDef.getControlType() == 3) {
                    return new SelectMultiData(vector);
                }
                if (questionDef.getControlType() == 2) {
                    return new SelectOneData((Selection)vector.elementAt(0));
                }
                throw new RuntimeException("can't happen");
            }
            return null;
        }
        return this.mTreeElement.getValue();
    }

    public String getAnswerText() {
        String string;
        String string2;
        IAnswerData iAnswerData = this.getAnswerValue();
        if (iAnswerData == null) {
            return null;
        }
        if (iAnswerData instanceof SelectOneData) {
            string2 = this.getSelectItemText((Selection)iAnswerData.getValue());
        } else if (iAnswerData instanceof SelectMultiData) {
            string = "";
            Vector vector = (Vector)iAnswerData.getValue();
            for (Selection selection : vector) {
                string = string + this.getSelectItemText(selection) + " ";
            }
            string2 = string;
        } else {
            string2 = iAnswerData.getDisplayText();
        }
        if (this.getControlType() == 5) {
            string = "";
            for (int i = 0; i < string2.length(); ++i) {
                string = string + "*";
            }
            string2 = string;
        }
        return string2;
    }

    public String getConstraintText() {
        if (this.mTreeElement.getConstraint() == null) {
            return null;
        }
        return this.mTreeElement.getConstraint().constraintMsg;
    }

    public Vector<SelectChoice> getSelectChoices() {
        QuestionDef questionDef = this.getQuestion();
        ItemsetBinding itemsetBinding = questionDef.getDynamicChoices();
        if (itemsetBinding != null) {
            if (!this.dynamicChoicesPopulated) {
                this.form.populateDynamicChoices(itemsetBinding, this.mTreeElement.getRef());
                this.dynamicChoicesPopulated = true;
            }
            return itemsetBinding.getChoices();
        }
        return questionDef.getChoices();
    }

    public void expireDynamicChoices() {
        this.dynamicChoicesPopulated = false;
        ItemsetBinding itemsetBinding = this.getQuestion().getDynamicChoices();
        if (itemsetBinding != null) {
            itemsetBinding.clearChoices();
        }
    }

    public boolean isRequired() {
        return this.mTreeElement.required;
    }

    public boolean isReadOnly() {
        return !this.mTreeElement.isEnabled();
    }

    public QuestionDef getQuestion() {
        return (QuestionDef)this.element;
    }

    @Override
    public void register(IQuestionWidget iQuestionWidget) {
        super.register(iQuestionWidget);
        this.mTreeElement.registerStateObserver(this);
    }

    @Override
    public void unregister() {
        this.mTreeElement.unregisterStateObserver(this);
        super.unregister();
    }

    @Override
    public void formElementStateChanged(TreeElement treeElement, int n) {
        if (this.mTreeElement != treeElement) {
            throw new IllegalStateException("Widget received event from foreign question");
        }
        if (this.viewWidget != null) {
            this.viewWidget.refreshWidget(n);
        }
    }

    public String getHelpText() {
        if (!(this.element instanceof QuestionDef)) {
            throw new RuntimeException("Can't get HelpText for Elements that are not Questions!");
        }
        String string = ((QuestionDef)this.element).getHelpTextID();
        String string2 = ((QuestionDef)this.element).getHelpText();
        try {
            if (string != null) {
                string2 = this.localizer().getLocalizedText(string);
            }
        }
        catch (NoLocalizedTextException noLocalizedTextException) {
        }
        catch (UnregisteredLocaleException unregisteredLocaleException) {
            System.err.println("Warning: No Locale set yet (while attempting to getHelpText())");
        }
        catch (Exception exception) {
            Logger.exception("FormEntryPrompt.getHelpText", exception);
            exception.printStackTrace();
        }
        return string2;
    }

    public String getSelectItemText(Selection selection) {
        if (!(this.getFormElement() instanceof QuestionDef)) {
            throw new RuntimeException("Can't retrieve question text for non-QuestionDef form elements!");
        }
        if (selection == null) {
            throw new IllegalArgumentException("Cannot use null as an argument!");
        }
        String string = selection.choice.getTextID();
        if (string == null || string == "") {
            return this.substituteStringArgs(selection.choice.getLabelInnerText());
        }
        String string2 = this.getIText(string, "long");
        if (string2 == null) {
            string2 = this.getIText(string, null);
        }
        return this.substituteStringArgs(string2);
    }

    public String getSelectChoiceText(SelectChoice selectChoice) {
        return this.getSelectItemText(selectChoice.selection());
    }

    public String getSpecialFormSelectItemText(Selection selection, String string) {
        if (selection == null) {
            throw new IllegalArgumentException("Cannot use null as an argument for Selection!");
        }
        String string2 = selection.choice.getTextID();
        if (string2 == null || string2.equals("")) {
            return null;
        }
        String string3 = this.getIText(string2, string);
        return this.substituteStringArgs(string3);
    }

    public String getSpecialFormSelectChoiceText(SelectChoice selectChoice, String string) {
        return this.getSpecialFormSelectItemText(selectChoice.selection(), string);
    }
}

