/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.parser.XPathSyntaxException;

public class XPathReference
implements IDataReference {
    private TreeReference ref;
    private String nodeset;

    public XPathReference() {
    }

    public XPathReference(String string) {
        this.ref = XPathReference.getPathExpr(string).getReference();
        this.nodeset = string;
    }

    public static XPathPathExpr getPathExpr(String string) {
        XPathExpression xPathExpression;
        boolean bl = false;
        try {
            xPathExpression = XPathParseTool.parseXPath(string);
            if (!(xPathExpression instanceof XPathPathExpr)) {
                bl = true;
                throw new XPathSyntaxException();
            }
        }
        catch (XPathSyntaxException xPathSyntaxException) {
            if (bl) {
                throw new RuntimeException("Expected XPath path, got XPath expression: [" + string + "]");
            }
            throw new RuntimeException("Parse error in XPath path: [" + string + "]");
        }
        return (XPathPathExpr)xPathExpression;
    }

    public XPathReference(XPathPathExpr xPathPathExpr) {
        this.ref = xPathPathExpr.getReference();
    }

    public XPathReference(TreeReference treeReference) {
        this.ref = treeReference;
    }

    public Object getReference() {
        return this.ref;
    }

    public void setReference(Object object) {
    }

    public boolean equals(Object object) {
        if (object instanceof XPathReference) {
            return this.ref.equals(((XPathReference)object).ref);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.nodeset = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.ref = (TreeReference)ExtUtil.read(dataInputStream, TreeReference.class, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.nodeset));
        ExtUtil.write(dataOutputStream, this.ref);
    }
}

