/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.MultiPointerAnswerData;
import org.javarosa.core.model.data.PointerAnswerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.utils.DateUtils;
import org.kxml2.kdom.Element;

public class XFormAnswerDataSerializer
implements IAnswerDataSerializer {
    public static final String DELIMITER = " ";
    Vector additionalSerializers = new Vector();

    public void registerAnswerSerializer(IAnswerDataSerializer iAnswerDataSerializer) {
        this.additionalSerializers.addElement(iAnswerDataSerializer);
    }

    public boolean canSerialize(IAnswerData iAnswerData) {
        return iAnswerData instanceof StringData || iAnswerData instanceof DateData || iAnswerData instanceof TimeData || iAnswerData instanceof SelectMultiData || iAnswerData instanceof SelectOneData || iAnswerData instanceof IntegerData || iAnswerData instanceof DecimalData || iAnswerData instanceof PointerAnswerData || iAnswerData instanceof MultiPointerAnswerData || iAnswerData instanceof GeoPointData || iAnswerData instanceof DateTimeData || iAnswerData instanceof UncastData;
    }

    public Object serializeAnswerData(UncastData uncastData) {
        return uncastData.getString();
    }

    public Object serializeAnswerData(StringData stringData) {
        return (String)stringData.getValue();
    }

    public Object serializeAnswerData(DateData dateData) {
        return DateUtils.formatDate((Date)dateData.getValue(), 1);
    }

    public Object serializeAnswerData(DateTimeData dateTimeData) {
        return DateUtils.formatDateTime((Date)dateTimeData.getValue(), 1);
    }

    public Object serializeAnswerData(TimeData timeData) {
        return DateUtils.formatTime((Date)timeData.getValue(), 1);
    }

    public Object serializeAnswerData(PointerAnswerData pointerAnswerData) {
        IDataPointer iDataPointer = (IDataPointer)pointerAnswerData.getValue();
        return iDataPointer.getDisplayText();
    }

    public Object serializeAnswerData(MultiPointerAnswerData multiPointerAnswerData) {
        IDataPointer[] iDataPointerArray = (IDataPointer[])multiPointerAnswerData.getValue();
        if (iDataPointerArray.length == 1) {
            return iDataPointerArray[0].getDisplayText();
        }
        Element element = new Element();
        for (int i = 0; i < iDataPointerArray.length; ++i) {
            Element element2 = new Element();
            element2.setName("data");
            element2.addChild(4, iDataPointerArray[i].getDisplayText());
            element.addChild(2, element2);
        }
        return element;
    }

    public Object serializeAnswerData(SelectMultiData selectMultiData) {
        Vector vector = (Vector)selectMultiData.getValue();
        Enumeration enumeration = vector.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            Selection selection = (Selection)enumeration.nextElement();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(DELIMITER);
            }
            stringBuffer.append(selection.getValue());
        }
        return stringBuffer.toString();
    }

    public Object serializeAnswerData(SelectOneData selectOneData) {
        return ((Selection)selectOneData.getValue()).getValue();
    }

    public Object serializeAnswerData(IntegerData integerData) {
        return ((Integer)integerData.getValue()).toString();
    }

    public Object serializeAnswerData(DecimalData decimalData) {
        return ((Double)decimalData.getValue()).toString();
    }

    public Object serializeAnswerData(GeoPointData geoPointData) {
        return geoPointData.getDisplayText();
    }

    public Object serializeAnswerData(BooleanData booleanData) {
        if (((Boolean)booleanData.getValue()).booleanValue()) {
            return "1";
        }
        return "0";
    }

    public Object serializeAnswerData(IAnswerData iAnswerData, int n) {
        Object object;
        Enumeration enumeration = this.additionalSerializers.elements();
        while (enumeration.hasMoreElements()) {
            object = (IAnswerDataSerializer)enumeration.nextElement();
            if (!object.canSerialize(iAnswerData)) continue;
            return object.serializeAnswerData(iAnswerData, n);
        }
        object = this.serializeAnswerData(iAnswerData);
        return object;
    }

    public Object serializeAnswerData(IAnswerData iAnswerData) {
        if (iAnswerData instanceof StringData) {
            return this.serializeAnswerData((StringData)iAnswerData);
        }
        if (iAnswerData instanceof SelectMultiData) {
            return this.serializeAnswerData((SelectMultiData)iAnswerData);
        }
        if (iAnswerData instanceof SelectOneData) {
            return this.serializeAnswerData((SelectOneData)iAnswerData);
        }
        if (iAnswerData instanceof IntegerData) {
            return this.serializeAnswerData((IntegerData)iAnswerData);
        }
        if (iAnswerData instanceof DecimalData) {
            return this.serializeAnswerData((DecimalData)iAnswerData);
        }
        if (iAnswerData instanceof DateData) {
            return this.serializeAnswerData((DateData)iAnswerData);
        }
        if (iAnswerData instanceof TimeData) {
            return this.serializeAnswerData((TimeData)iAnswerData);
        }
        if (iAnswerData instanceof PointerAnswerData) {
            return this.serializeAnswerData((PointerAnswerData)iAnswerData);
        }
        if (iAnswerData instanceof MultiPointerAnswerData) {
            return this.serializeAnswerData((MultiPointerAnswerData)iAnswerData);
        }
        if (iAnswerData instanceof GeoPointData) {
            return this.serializeAnswerData((GeoPointData)iAnswerData);
        }
        if (iAnswerData instanceof DateTimeData) {
            return this.serializeAnswerData((DateTimeData)iAnswerData);
        }
        if (iAnswerData instanceof BooleanData) {
            return this.serializeAnswerData((BooleanData)iAnswerData);
        }
        if (iAnswerData instanceof UncastData) {
            return this.serializeAnswerData((UncastData)iAnswerData);
        }
        return null;
    }

    public Boolean containsExternalData(IAnswerData iAnswerData) {
        Enumeration enumeration = this.additionalSerializers.elements();
        while (enumeration.hasMoreElements()) {
            IAnswerDataSerializer iAnswerDataSerializer = (IAnswerDataSerializer)enumeration.nextElement();
            Boolean bl = iAnswerDataSerializer.containsExternalData(iAnswerData);
            if (bl == null) continue;
            return bl;
        }
        if (iAnswerData instanceof PointerAnswerData || iAnswerData instanceof MultiPointerAnswerData) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public IDataPointer[] retrieveExternalDataPointer(IAnswerData iAnswerData) {
        IDataPointer[] iDataPointerArray;
        Enumeration enumeration = this.additionalSerializers.elements();
        while (enumeration.hasMoreElements()) {
            iDataPointerArray = (IDataPointer[])enumeration.nextElement();
            Boolean bl = iDataPointerArray.containsExternalData(iAnswerData);
            if (bl == null) continue;
            return iDataPointerArray.retrieveExternalDataPointer(iAnswerData);
        }
        if (iAnswerData instanceof PointerAnswerData) {
            iDataPointerArray = new IDataPointer[]{(IDataPointer)((PointerAnswerData)iAnswerData).getValue()};
            return iDataPointerArray;
        }
        if (iAnswerData instanceof MultiPointerAnswerData) {
            return (IDataPointer[])((MultiPointerAnswerData)iAnswerData).getValue();
        }
        return null;
    }
}

