/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.log.FatalException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathParseTool;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathUnaryOpExpr;
import org.javarosa.xpath.parser.XPathSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathConditional
implements IConditionExpr {
    private XPathExpression expr;
    public String xpath;
    public boolean hasNow;

    public XPathConditional(String string) throws XPathSyntaxException {
        this.hasNow = false;
        if (string.indexOf("now()") > -1) {
            this.hasNow = true;
        }
        this.expr = XPathParseTool.parseXPath(string);
        this.xpath = string;
    }

    public XPathConditional(XPathExpression xPathExpression) {
        this.expr = xPathExpression;
    }

    public XPathConditional() {
    }

    public XPathExpression getExpr() {
        return this.expr;
    }

    @Override
    public Object evalRaw(FormInstance formInstance, EvaluationContext evaluationContext) {
        return XPathFuncExpr.unpack(this.expr.eval(formInstance, evaluationContext));
    }

    @Override
    public boolean eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        return XPathFuncExpr.toBoolean(this.evalRaw(formInstance, evaluationContext));
    }

    @Override
    public String evalReadable(FormInstance formInstance, EvaluationContext evaluationContext) {
        return XPathFuncExpr.toString(this.evalRaw(formInstance, evaluationContext));
    }

    @Override
    public Vector<TreeReference> evalNodeset(FormInstance formInstance, EvaluationContext evaluationContext) {
        if (this.expr instanceof XPathPathExpr) {
            return ((XPathPathExpr)this.expr).eval((FormInstance)formInstance, (EvaluationContext)evaluationContext).nodes;
        }
        throw new FatalException("evalNodeset: must be path expression");
    }

    @Override
    public Vector getTriggers() {
        Vector vector = new Vector();
        XPathConditional.getTriggers(this.expr, vector);
        return vector;
    }

    private static void getTriggers(XPathExpression xPathExpression, Vector vector) {
        if (xPathExpression instanceof XPathPathExpr) {
            TreeReference treeReference = ((XPathPathExpr)xPathExpression).getReference();
            if (!vector.contains(treeReference)) {
                vector.addElement(treeReference);
            }
        } else if (xPathExpression instanceof XPathBinaryOpExpr) {
            XPathConditional.getTriggers(((XPathBinaryOpExpr)xPathExpression).a, vector);
            XPathConditional.getTriggers(((XPathBinaryOpExpr)xPathExpression).b, vector);
        } else if (xPathExpression instanceof XPathUnaryOpExpr) {
            XPathConditional.getTriggers(((XPathUnaryOpExpr)xPathExpression).a, vector);
        } else if (xPathExpression instanceof XPathFuncExpr) {
            XPathFuncExpr xPathFuncExpr = (XPathFuncExpr)xPathExpression;
            for (int i = 0; i < xPathFuncExpr.args.length; ++i) {
                XPathConditional.getTriggers(xPathFuncExpr.args[i], vector);
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof XPathConditional) {
            XPathConditional xPathConditional = (XPathConditional)object;
            return this.expr.equals(xPathConditional.expr);
        }
        return false;
    }

    @Override
    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.expr = (XPathExpression)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
        this.hasNow = ExtUtil.readBool(dataInputStream);
    }

    @Override
    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.expr));
        ExtUtil.writeBool(dataOutputStream, this.hasNow);
    }

    public String toString() {
        return "xpath[" + this.expr.toString() + "]";
    }
}

