/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath;

import java.util.Vector;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.expr.XPathPathExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathNodeset {
    Vector<TreeReference> nodes;
    FormInstance instance;
    EvaluationContext ec;

    public XPathNodeset(Vector<TreeReference> vector, FormInstance formInstance, EvaluationContext evaluationContext) {
        this.nodes = vector;
        this.instance = formInstance;
        this.ec = evaluationContext;
    }

    public Object unpack() {
        if (this.size() == 0) {
            return XPathPathExpr.unpackValue(null);
        }
        if (this.size() > 1) {
            throw new XPathTypeMismatchException("nodeset has more than one node [" + this.nodeContents() + "]; cannot convert to value");
        }
        return this.getValAt(0);
    }

    public Object[] toArgList() {
        Object[] objectArray = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Object object = this.getValAt(i);
            if (object == null) {
                throw new RuntimeException("retrived a null value out of a nodeset! shouldn't happen!");
            }
            objectArray[i] = object;
        }
        return objectArray;
    }

    public int size() {
        return this.nodes.size();
    }

    public TreeReference getRefAt(int n) {
        return this.nodes.elementAt(n);
    }

    public Object getValAt(int n) {
        return XPathPathExpr.getRefValue(this.instance, this.ec, this.getRefAt(n));
    }

    private String nodeContents() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nodes.size(); ++i) {
            stringBuffer.append(this.nodes.elementAt(i).toString());
            if (i >= this.nodes.size() - 1) continue;
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }
}

