/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathBoolExpr
extends XPathBinaryOpExpr {
    public static final int AND = 0;
    public static final int OR = 1;
    public int op;

    public XPathBoolExpr() {
    }

    public XPathBoolExpr(int n, XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
        this.op = n;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        boolean bl = XPathFuncExpr.toBoolean(this.a.eval(formInstance, evaluationContext));
        if (!bl && this.op == 0 || bl && this.op == 1) {
            return new Boolean(bl);
        }
        boolean bl2 = XPathFuncExpr.toBoolean(this.b.eval(formInstance, evaluationContext));
        boolean bl3 = false;
        switch (this.op) {
            case 0: {
                bl3 = bl && bl2;
                break;
            }
            case 1: {
                bl3 = bl || bl2;
            }
        }
        return new Boolean(bl3);
    }

    public String toString() {
        String string = null;
        switch (this.op) {
            case 0: {
                string = "and";
                break;
            }
            case 1: {
                string = "or";
            }
        }
        return super.toString(string);
    }

    public boolean equals(Object object) {
        if (object instanceof XPathBoolExpr) {
            XPathBoolExpr xPathBoolExpr = (XPathBoolExpr)object;
            return super.equals(object) && this.op == xPathBoolExpr.op;
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.op = ExtUtil.readInt(dataInputStream);
        super.readExternal(dataInputStream, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.op);
        super.writeExternal(dataOutputStream);
    }
}

