/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathBinaryOpExpr;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFuncExpr;

public class XPathEqExpr
extends XPathBinaryOpExpr {
    public boolean equal;

    public XPathEqExpr() {
    }

    public XPathEqExpr(boolean bl, XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        super(xPathExpression, xPathExpression2);
        this.equal = bl;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        Object object = XPathFuncExpr.unpack(this.a.eval(formInstance, evaluationContext));
        Object object2 = XPathFuncExpr.unpack(this.b.eval(formInstance, evaluationContext));
        boolean bl = false;
        if (object instanceof Boolean || object2 instanceof Boolean) {
            if (!(object instanceof Boolean)) {
                object = XPathFuncExpr.toBoolean(object);
            } else if (!(object2 instanceof Boolean)) {
                object2 = XPathFuncExpr.toBoolean(object2);
            }
            boolean bl2 = (Boolean)object;
            boolean bl3 = (Boolean)object2;
            bl = bl2 == bl3;
        } else if (object instanceof Double || object2 instanceof Double) {
            if (!(object instanceof Double)) {
                object = XPathFuncExpr.toNumeric(object);
            } else if (!(object2 instanceof Double)) {
                object2 = XPathFuncExpr.toNumeric(object2);
            }
            double d = (Double)object;
            double d2 = (Double)object2;
            bl = Math.abs(d - d2) < 1.0E-12;
        } else {
            object = XPathFuncExpr.toString(object);
            object2 = XPathFuncExpr.toString(object2);
            bl = object.equals(object2);
        }
        return new Boolean(this.equal ? bl : !bl);
    }

    public String toString() {
        return super.toString(this.equal ? "==" : "!=");
    }

    public boolean equals(Object object) {
        if (object instanceof XPathEqExpr) {
            XPathEqExpr xPathEqExpr = (XPathEqExpr)object;
            return super.equals(object) && this.equal == xPathEqExpr.equal;
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.equal = ExtUtil.readBool(dataInputStream);
        super.readExternal(dataInputStream, prototypeFactory);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeBool(dataOutputStream, this.equal);
        super.writeExternal(dataOutputStream);
    }
}

