/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import me.regexp.RE;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.MathUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.IExprDataType;
import org.javarosa.xpath.XPathNodeset;
import org.javarosa.xpath.XPathTypeMismatchException;
import org.javarosa.xpath.XPathUnhandledException;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;

public class XPathFuncExpr
extends XPathExpression {
    public XPathQName id;
    public XPathExpression[] args;

    public XPathFuncExpr() {
    }

    public XPathFuncExpr(XPathQName xPathQName, XPathExpression[] xPathExpressionArray) {
        this.id = xPathQName;
        this.args = xPathExpressionArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{func-expr:");
        stringBuffer.append(this.id.toString());
        stringBuffer.append(",{");
        for (int i = 0; i < this.args.length; ++i) {
            stringBuffer.append(this.args[i].toString());
            if (i >= this.args.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof XPathFuncExpr) {
            XPathFuncExpr xPathFuncExpr = (XPathFuncExpr)object;
            if (!this.id.equals(xPathFuncExpr.id) || this.args.length != xPathFuncExpr.args.length) {
                return false;
            }
            return ExtUtil.arrayEquals(this.args, xPathFuncExpr.args);
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.id = (XPathQName)ExtUtil.read(dataInputStream, XPathQName.class);
        Vector vector = (Vector)ExtUtil.read(dataInputStream, new ExtWrapListPoly(), prototypeFactory);
        this.args = new XPathExpression[vector.size()];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = (XPathExpression)vector.elementAt(i);
        }
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        Vector<XPathExpression> vector = new Vector<XPathExpression>();
        for (int i = 0; i < this.args.length; ++i) {
            vector.addElement(this.args[i]);
        }
        ExtUtil.write(dataOutputStream, this.id);
        ExtUtil.write(dataOutputStream, new ExtWrapListPoly(vector));
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        String string = this.id.toString();
        Object[] objectArray = new Object[this.args.length];
        Hashtable hashtable = evaluationContext.getFunctionHandlers();
        for (int i = 0; i < this.args.length; ++i) {
            objectArray[i] = this.args[i].eval(formInstance, evaluationContext);
        }
        if (string.equals("true") && this.args.length == 0) {
            return Boolean.TRUE;
        }
        if (string.equals("false") && this.args.length == 0) {
            return Boolean.FALSE;
        }
        if (string.equals("boolean") && this.args.length == 1) {
            return XPathFuncExpr.toBoolean(objectArray[0]);
        }
        if (string.equals("number") && this.args.length == 1) {
            return XPathFuncExpr.toNumeric(objectArray[0]);
        }
        if (string.equals("int") && this.args.length == 1) {
            return XPathFuncExpr.toInt(objectArray[0]);
        }
        if (string.equals("string") && this.args.length == 1) {
            return XPathFuncExpr.toString(objectArray[0]);
        }
        if (string.equals("date") && this.args.length == 1) {
            return XPathFuncExpr.toDate(objectArray[0]);
        }
        if (string.equals("not") && this.args.length == 1) {
            return XPathFuncExpr.boolNot(objectArray[0]);
        }
        if (string.equals("boolean-from-string") && this.args.length == 1) {
            return XPathFuncExpr.boolStr(objectArray[0]);
        }
        if (string.equals("format-date") && this.args.length == 2) {
            return XPathFuncExpr.dateStr(objectArray[0], objectArray[1]);
        }
        if (string.equals("if") && this.args.length == 3) {
            return XPathFuncExpr.ifThenElse(objectArray[0], objectArray[1], objectArray[2]);
        }
        if ((string.equals("selected") || string.equals("is-selected")) && this.args.length == 2) {
            return XPathFuncExpr.multiSelected(objectArray[0], objectArray[1]);
        }
        if (string.equals("count-selected") && this.args.length == 1) {
            return XPathFuncExpr.countSelected(objectArray[0]);
        }
        if (string.equals("coalesce") && this.args.length == 2) {
            return !XPathFuncExpr.isNull(objectArray[0]) ? objectArray[0] : objectArray[1];
        }
        if (string.equals("count") && this.args.length == 1) {
            return XPathFuncExpr.count(objectArray[0]);
        }
        if (string.equals("sum") && this.args.length == 1) {
            if (objectArray[0] instanceof XPathNodeset) {
                return XPathFuncExpr.sum(((XPathNodeset)objectArray[0]).toArgList());
            }
            throw new XPathTypeMismatchException("not a nodeset");
        }
        if (string.equals("today") && this.args.length == 0) {
            return DateUtils.roundDate(new Date());
        }
        if (string.equals("now") && this.args.length == 0) {
            return new Date();
        }
        if (string.equals("concat")) {
            if (this.args.length == 1 && objectArray[0] instanceof XPathNodeset) {
                return XPathFuncExpr.join("", ((XPathNodeset)objectArray[0]).toArgList());
            }
            return XPathFuncExpr.join("", objectArray);
        }
        if (string.equals("join") && this.args.length >= 1) {
            if (this.args.length == 2 && objectArray[1] instanceof XPathNodeset) {
                return XPathFuncExpr.join(objectArray[0], ((XPathNodeset)objectArray[1]).toArgList());
            }
            return XPathFuncExpr.join(objectArray[0], XPathFuncExpr.subsetArgList(objectArray, 1));
        }
        if (string.equals("checklist") && this.args.length >= 2) {
            if (this.args.length == 3 && objectArray[2] instanceof XPathNodeset) {
                return XPathFuncExpr.checklist(objectArray[0], objectArray[1], ((XPathNodeset)objectArray[2]).toArgList());
            }
            return XPathFuncExpr.checklist(objectArray[0], objectArray[1], XPathFuncExpr.subsetArgList(objectArray, 2));
        }
        if (string.equals("weighted-checklist") && this.args.length >= 2 && this.args.length % 2 == 0) {
            if (this.args.length == 4 && objectArray[2] instanceof XPathNodeset && objectArray[3] instanceof XPathNodeset) {
                Object[] objectArray2;
                Object[] objectArray3 = ((XPathNodeset)objectArray[2]).toArgList();
                if (objectArray3.length != (objectArray2 = ((XPathNodeset)objectArray[3]).toArgList()).length) {
                    throw new XPathTypeMismatchException("weighted-checklist: nodesets not same length");
                }
                return XPathFuncExpr.checklistWeighted(objectArray[0], objectArray[1], objectArray3, objectArray2);
            }
            return XPathFuncExpr.checklistWeighted(objectArray[0], objectArray[1], XPathFuncExpr.subsetArgList(objectArray, 2, 2), XPathFuncExpr.subsetArgList(objectArray, 3, 2));
        }
        if (string.equals("regex") && this.args.length == 2) {
            return XPathFuncExpr.regex(objectArray[0], objectArray[1]);
        }
        if (string.equals("depend") && this.args.length >= 1) {
            return objectArray[0];
        }
        IFunctionHandler iFunctionHandler = (IFunctionHandler)hashtable.get(string);
        if (iFunctionHandler != null) {
            return XPathFuncExpr.evalCustomFunction(iFunctionHandler, objectArray);
        }
        throw new XPathUnhandledException("function '" + string + "'");
    }

    private static Object evalCustomFunction(IFunctionHandler iFunctionHandler, Object[] objectArray) {
        Vector vector = iFunctionHandler.getPrototypes();
        Enumeration enumeration = vector.elements();
        Object[] objectArray2 = null;
        while (objectArray2 == null && enumeration.hasMoreElements()) {
            objectArray2 = XPathFuncExpr.matchPrototype(objectArray, (Class[])enumeration.nextElement());
        }
        if (objectArray2 != null) {
            return iFunctionHandler.eval(objectArray2);
        }
        if (iFunctionHandler.rawArgs()) {
            return iFunctionHandler.eval(objectArray);
        }
        throw new XPathTypeMismatchException("for function '" + iFunctionHandler.getName() + "'");
    }

    private static Object[] matchPrototype(Object[] objectArray, Class[] classArray) {
        Object[] objectArray2 = null;
        if (classArray.length == objectArray.length) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                objectArray2[i] = null;
                if (classArray[i].isAssignableFrom(objectArray[i].getClass())) {
                    objectArray2[i] = objectArray[i];
                } else {
                    try {
                        if (classArray[i] == Boolean.class) {
                            objectArray2[i] = XPathFuncExpr.toBoolean(objectArray[i]);
                        } else if (classArray[i] == Double.class) {
                            objectArray2[i] = XPathFuncExpr.toNumeric(objectArray[i]);
                        } else if (classArray[i] == String.class) {
                            objectArray2[i] = XPathFuncExpr.toString(objectArray[i]);
                        } else if (classArray[i] == Date.class) {
                            objectArray2[i] = XPathFuncExpr.toDate(objectArray[i]);
                        }
                    }
                    catch (XPathTypeMismatchException xPathTypeMismatchException) {
                        // empty catch block
                    }
                }
                if (objectArray2[i] != null) continue;
                return null;
            }
        }
        return objectArray2;
    }

    public static boolean isNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).length() == 0) {
            return true;
        }
        return object instanceof Double && ((Double)object).isNaN();
    }

    public static Boolean toBoolean(Object object) {
        Boolean bl = null;
        if ((object = XPathFuncExpr.unpack(object)) instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof Double) {
            double d = (Double)object;
            bl = new Boolean(Math.abs(d) > 1.0E-12 && !Double.isNaN(d));
        } else if (object instanceof String) {
            String string = (String)object;
            bl = new Boolean(string.length() > 0);
        } else if (object instanceof Date) {
            bl = Boolean.TRUE;
        } else if (object instanceof IExprDataType) {
            bl = ((IExprDataType)object).toBoolean();
        }
        if (bl != null) {
            return bl;
        }
        throw new XPathTypeMismatchException("converting to boolean");
    }

    public static Double toNumeric(Object object) {
        Double d = null;
        if ((object = XPathFuncExpr.unpack(object)) instanceof Boolean) {
            d = new Double((Boolean)object != false ? 1.0 : 0.0);
        } else if (object instanceof Double) {
            d = (Double)object;
        } else if (object instanceof String) {
            String string = (String)object;
            try {
                string = string.trim();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '-' || c == '.' || c >= '0' && c <= '9') continue;
                    throw new NumberFormatException();
                }
                double d2 = Double.parseDouble(string);
                d = new Double(d2);
            }
            catch (NumberFormatException numberFormatException) {
                d = new Double(Double.NaN);
            }
        } else if (object instanceof Date) {
            d = new Double(DateUtils.daysSinceEpoch((Date)object));
        } else if (object instanceof IExprDataType) {
            d = ((IExprDataType)object).toNumeric();
        }
        if (d != null) {
            return d;
        }
        throw new XPathTypeMismatchException("converting to numeric");
    }

    public static Double toInt(Object object) {
        Double d = XPathFuncExpr.toNumeric(object);
        if (d.isInfinite() || d.isNaN()) {
            return d;
        }
        if (d >= 9.223372036854776E18 || d <= -9.223372036854776E18) {
            return d;
        }
        long l = d.longValue();
        Double d2 = new Double(l);
        if (l == 0L && (d < 0.0 || d.equals(new Double(-0.0)))) {
            d2 = new Double(-0.0);
        }
        return d2;
    }

    public static String toString(Object object) {
        String string = null;
        if ((object = XPathFuncExpr.unpack(object)) instanceof Boolean) {
            string = (Boolean)object != false ? "true" : "false";
        } else if (object instanceof Double) {
            double d = (Double)object;
            string = Double.isNaN(d) ? "NaN" : (Math.abs(d) < 1.0E-12 ? "0" : (Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "Infinity" : (Math.abs(d - (double)((int)d)) < 1.0E-12 ? String.valueOf((int)d) : String.valueOf(d))));
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Date) {
            string = DateUtils.formatDate((Date)object, 1);
        } else if (object instanceof IExprDataType) {
            string = ((Object)((IExprDataType)object)).toString();
        }
        if (string != null) {
            return string;
        }
        throw new XPathTypeMismatchException("converting to string");
    }

    public static Object toDate(Object object) {
        if ((object = XPathFuncExpr.unpack(object)) instanceof Double) {
            Double d = XPathFuncExpr.toInt(object);
            if (d.isNaN()) {
                return d;
            }
            if (d.isInfinite() || d > 2.147483647E9 || d < -2.147483648E9) {
                throw new XPathTypeMismatchException("converting out-of-range value to date");
            }
            return DateUtils.dateAdd(DateUtils.getDate(1970, 1, 1), d.intValue());
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return string;
            }
            Date date = DateUtils.parseDate(string);
            if (date == null) {
                throw new XPathTypeMismatchException("converting to date");
            }
            return date;
        }
        if (object instanceof Date) {
            return DateUtils.roundDate((Date)object);
        }
        throw new XPathTypeMismatchException("converting to date");
    }

    public static Boolean boolNot(Object object) {
        boolean bl = XPathFuncExpr.toBoolean(object);
        return new Boolean(!bl);
    }

    public static Boolean boolStr(Object object) {
        String string = XPathFuncExpr.toString(object);
        if (string.equalsIgnoreCase("true") || string.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String dateStr(Object object, Object object2) {
        if ((object = XPathFuncExpr.toDate(object)) instanceof Date) {
            return DateUtils.format((Date)object, XPathFuncExpr.toString(object2));
        }
        return "";
    }

    public static Object ifThenElse(Object object, Object object2, Object object3) {
        boolean bl = XPathFuncExpr.toBoolean(object);
        return bl ? object2 : object3;
    }

    public static Boolean multiSelected(Object object, Object object2) {
        String string = (String)XPathFuncExpr.unpack(object);
        String string2 = ((String)XPathFuncExpr.unpack(object2)).trim();
        return new Boolean((" " + string + " ").indexOf(" " + string2 + " ") != -1);
    }

    public static Double countSelected(Object object) {
        String string = (String)XPathFuncExpr.unpack(object);
        return new Double(DateUtils.split(string, " ", true).size());
    }

    public static Double count(Object object) {
        if (object instanceof XPathNodeset) {
            return new Double(((XPathNodeset)object).size());
        }
        throw new XPathTypeMismatchException("not a nodeset");
    }

    public static Double sum(Object[] objectArray) {
        double d = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            d += XPathFuncExpr.toNumeric(objectArray[i]).doubleValue();
        }
        return new Double(d);
    }

    public static String join(Object object, Object[] objectArray) {
        String string = XPathFuncExpr.toString(object);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(XPathFuncExpr.toString(objectArray[i]));
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static Boolean checklist(Object object, Object object2, Object[] objectArray) {
        int n = XPathFuncExpr.toNumeric(object).intValue();
        int n2 = XPathFuncExpr.toNumeric(object2).intValue();
        int n3 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!XPathFuncExpr.toBoolean(objectArray[i]).booleanValue()) continue;
            ++n3;
        }
        return new Boolean(!(n >= 0 && n3 < n || n2 >= 0 && n3 > n2));
    }

    public static Boolean checklistWeighted(Object object, Object object2, Object[] objectArray, Object[] objectArray2) {
        double d = XPathFuncExpr.toNumeric(object);
        double d2 = XPathFuncExpr.toNumeric(object2);
        double d3 = 0.0;
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl = XPathFuncExpr.toBoolean(objectArray[i]);
            double d4 = XPathFuncExpr.toNumeric(objectArray2[i]);
            if (!bl) continue;
            d3 += d4;
        }
        return new Boolean(d3 >= d && d3 <= d2);
    }

    public static Boolean regex(Object object, Object object2) {
        String string = XPathFuncExpr.toString(object);
        String string2 = XPathFuncExpr.toString(object2);
        RE rE = new RE(string2);
        boolean bl = rE.match(string);
        return new Boolean(bl);
    }

    private static Object[] subsetArgList(Object[] objectArray, int n) {
        return XPathFuncExpr.subsetArgList(objectArray, n, 1);
    }

    private static Object[] subsetArgList(Object[] objectArray, int n, int n2) {
        if (n > objectArray.length || n2 < 1) {
            throw new RuntimeException("error in subsetting arglist");
        }
        Object[] objectArray2 = new Object[(int)MathUtils.divLongNotSuck(objectArray.length - n - 1, n2) + 1];
        int n3 = n;
        int n4 = 0;
        while (n3 < objectArray.length) {
            objectArray2[n4] = objectArray[n3];
            n3 += n2;
            ++n4;
        }
        return objectArray2;
    }

    public static Object unpack(Object object) {
        if (object instanceof XPathNodeset) {
            return ((XPathNodeset)object).unpack();
        }
        return object;
    }
}

