/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class GroupDef
implements IFormElement,
Localizable {
    private Vector children;
    private boolean repeat;
    private int id;
    private IDataReference binding;
    private String labelInnerText;
    private String appearanceAttr;
    private String textID;
    public String chooseCaption;
    public String addCaption;
    public String delCaption;
    public String doneCaption;
    public String addEmptyCaption;
    public String doneEmptyCaption;
    public String entryHeader;
    public String delHeader;
    public String mainHeader;
    Vector observers;
    public boolean noAddRemove = false;
    public IDataReference count = null;

    public GroupDef() {
        this(-1, null, false);
    }

    public GroupDef(int n, Vector vector, boolean bl) {
        this.setID(n);
        this.setChildren(vector);
        this.setRepeat(bl);
        this.observers = new Vector();
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public IDataReference getBind() {
        return this.binding;
    }

    public void setBind(IDataReference iDataReference) {
        this.binding = iDataReference;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setChildren(Vector vector) {
        this.children = vector == null ? new Vector() : vector;
    }

    public void addChild(IFormElement iFormElement) {
        this.children.addElement(iFormElement);
    }

    public IFormElement getChild(int n) {
        if (this.children == null || n >= this.children.size()) {
            return null;
        }
        return (IFormElement)this.children.elementAt(n);
    }

    public boolean getRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    public void setLabelInnerText(String string) {
        this.labelInnerText = string;
    }

    public String getAppearanceAttr() {
        return this.appearanceAttr;
    }

    public void setAppearanceAttr(String string) {
        this.appearanceAttr = string;
    }

    public void localeChanged(String string, Localizer localizer) {
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((IFormElement)enumeration.nextElement()).localeChanged(string, localizer);
        }
    }

    public IDataReference getCountReference() {
        return this.count;
    }

    public String toString() {
        return "<group>";
    }

    public int getDeepChildCount() {
        int n = 0;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            n += ((IFormElement)enumeration.nextElement()).getDeepChildCount();
        }
        return n;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.setID(ExtUtil.readInt(dataInputStream));
        this.setAppearanceAttr((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setBind((IDataReference)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory));
        this.setTextID((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setLabelInnerText((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setRepeat(ExtUtil.readBool(dataInputStream));
        this.setChildren((Vector)ExtUtil.read(dataInputStream, new ExtWrapListPoly(), prototypeFactory));
        this.noAddRemove = ExtUtil.readBool(dataInputStream);
        this.count = (IDataReference)ExtUtil.read(dataInputStream, new ExtWrapNullable(new ExtWrapTagged()), prototypeFactory);
        this.chooseCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.addCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.delCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.doneCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.addEmptyCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.doneEmptyCaption = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.entryHeader = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.delHeader = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.mainHeader = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.getID());
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getAppearanceAttr()));
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.getBind()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getTextID()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getLabelInnerText()));
        ExtUtil.writeBool(dataOutputStream, this.getRepeat());
        ExtUtil.write(dataOutputStream, new ExtWrapListPoly(this.getChildren()));
        ExtUtil.writeBool(dataOutputStream, this.noAddRemove);
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.count != null ? new ExtWrapTagged(this.count) : null));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.chooseCaption));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.addCaption));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.delCaption));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.doneCaption));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.addEmptyCaption));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.doneEmptyCaption));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.entryHeader));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.delHeader));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.mainHeader));
    }

    public void registerStateObserver(FormElementStateListener formElementStateListener) {
        if (!this.observers.contains(formElementStateListener)) {
            this.observers.addElement(formElementStateListener);
        }
    }

    public void unregisterStateObserver(FormElementStateListener formElementStateListener) {
        this.observers.removeElement(formElementStateListener);
    }

    public String getTextID() {
        return this.textID;
    }

    public void setTextID(String string) {
        if (string == null) {
            this.textID = null;
            return;
        }
        if (DateUtils.stringContains(string, ";")) {
            System.err.println("Warning: TextID contains ;form modifier:: \"" + string.substring(string.indexOf(";")) + "\"... will be stripped.");
            string = string.substring(0, string.indexOf(";"));
        }
        this.textID = string;
    }
}

