/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.condition.Triggerable;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class Condition
extends Triggerable {
    public static final int ACTION_NULL = 0;
    public static final int ACTION_SHOW = 1;
    public static final int ACTION_HIDE = 2;
    public static final int ACTION_ENABLE = 3;
    public static final int ACTION_DISABLE = 4;
    public static final int ACTION_LOCK = 5;
    public static final int ACTION_UNLOCK = 6;
    public static final int ACTION_REQUIRE = 7;
    public static final int ACTION_DONT_REQUIRE = 8;
    public int trueAction;
    public int falseAction;

    public Condition() {
    }

    public Condition(IConditionExpr iConditionExpr, int n, int n2, TreeReference treeReference) {
        this(iConditionExpr, n, n2, treeReference, new Vector());
    }

    public Condition(IConditionExpr iConditionExpr, int n, int n2, TreeReference treeReference, Vector vector) {
        super(iConditionExpr, treeReference);
        this.trueAction = n;
        this.falseAction = n2;
        this.targets = vector;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        return new Boolean(this.expr.eval(formInstance, evaluationContext));
    }

    public boolean evalBool(FormInstance formInstance, EvaluationContext evaluationContext) {
        return (Boolean)this.eval(formInstance, evaluationContext);
    }

    public void apply(TreeReference treeReference, Object object, FormInstance formInstance, FormDef formDef) {
        boolean bl = (Boolean)object;
        this.performAction(formInstance.resolveReference(treeReference), bl ? this.trueAction : this.falseAction);
    }

    public boolean canCascade() {
        return this.trueAction == 1 || this.trueAction == 2;
    }

    private void performAction(TreeElement treeElement, int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                treeElement.setRelevant(true);
                break;
            }
            case 2: {
                treeElement.setRelevant(false);
                break;
            }
            case 3: {
                treeElement.setEnabled(true);
                break;
            }
            case 4: {
                treeElement.setEnabled(false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                treeElement.setRequired(true);
                break;
            }
            case 8: {
                treeElement.setRequired(false);
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Condition) {
            Condition condition = (Condition)object;
            if (this == condition) {
                return true;
            }
            return this.trueAction == condition.trueAction && this.falseAction == condition.falseAction && super.equals(condition);
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        super.readExternal(dataInputStream, prototypeFactory);
        this.trueAction = ExtUtil.readInt(dataInputStream);
        this.falseAction = ExtUtil.readInt(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        super.writeExternal(dataOutputStream);
        ExtUtil.writeNumeric(dataOutputStream, this.trueAction);
        ExtUtil.writeNumeric(dataOutputStream, this.falseAction);
    }
}

