/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class MultiPointerAnswerData
implements IAnswerData {
    private IDataPointer[] data;

    public MultiPointerAnswerData() {
    }

    public MultiPointerAnswerData(IDataPointer[] iDataPointerArray) {
        this.data = iDataPointerArray;
    }

    public String getDisplayText() {
        String string = "";
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                string = string + ", ";
            }
            string = string + this.data[i].getDisplayText();
        }
        return string;
    }

    public Object getValue() {
        return this.data;
    }

    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.data = (IDataPointer[])object;
    }

    public IAnswerData clone() {
        return null;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        int n = dataInputStream.readInt();
        this.data = new IDataPointer[n];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (IDataPointer)ExtUtil.read(dataInputStream, new ExtWrapTagged());
        }
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.data[i]));
        }
    }

    public UncastData uncast() {
        String string = "";
        for (IDataPointer iDataPointer : this.data) {
            string = string + iDataPointer.getDisplayText() + " ";
        }
        if (string.length() > 0) {
            string = string.substring(0, string.length() - 1);
        }
        return new UncastData(string);
    }

    public MultiPointerAnswerData cast(UncastData uncastData) throws IllegalArgumentException {
        return null;
    }
}

