/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.CompactInstanceWrapper;
import org.javarosa.core.model.instance.utils.ITreeVisitor;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeElement
implements Externalizable {
    private String name;
    public int multiplicity;
    private TreeElement parent;
    public boolean repeatable;
    public boolean isAttribute;
    private IAnswerData value;
    private Vector children = new Vector();
    public int dataType = 0;
    public boolean required = false;
    private Constraint constraint = null;
    private String preloadHandler = null;
    private String preloadParams = null;
    private boolean relevant = true;
    private boolean enabled = true;
    private boolean relevantInherited = true;
    private boolean enabledInherited = true;
    private Vector observers;
    private Vector<TreeElement> attributes;
    private String namespace;

    public TreeElement() {
        this(null, 0);
    }

    public TreeElement(String string) {
        this(string, 0);
    }

    public TreeElement(String string, int n) {
        this.name = string;
        this.multiplicity = n;
        this.parent = null;
        this.attributes = new Vector(0);
    }

    public static TreeElement constructAttributeElement(String string, String string2) {
        TreeElement treeElement = new TreeElement(string2);
        treeElement.isAttribute = true;
        treeElement.namespace = string;
        treeElement.multiplicity = -4;
        return treeElement;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean isChildable() {
        return this.value == null;
    }

    public void setValue(IAnswerData iAnswerData) {
        if (!this.isLeaf()) {
            throw new RuntimeException("Can't set data value for node that has children!");
        }
        this.value = iAnswerData;
    }

    public TreeElement getChild(String string, int n) {
        if (string.equals("*")) {
            if (n == -2 || this.children.size() < n + 1) {
                return null;
            }
            return (TreeElement)this.children.elementAt(n);
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TreeElement treeElement = (TreeElement)this.children.elementAt(i);
            if (!string.equals(treeElement.getName()) || treeElement.getMult() != n) continue;
            return treeElement;
        }
        return null;
    }

    public Vector<TreeElement> getChildrenWithName(String string) {
        return this.getChildrenWithName(string, false);
    }

    private Vector<TreeElement> getChildrenWithName(String string, boolean bl) {
        Vector<TreeElement> vector = new Vector<TreeElement>();
        for (int i = 0; i < this.children.size(); ++i) {
            TreeElement treeElement = (TreeElement)this.children.elementAt(i);
            if (!treeElement.getName().equals(string) && !string.equals("*") || !bl && treeElement.multiplicity == -2) continue;
            vector.addElement(treeElement);
        }
        return vector;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public TreeElement getChildAt(int n) {
        return (TreeElement)this.children.elementAt(n);
    }

    public void addChild(TreeElement treeElement) {
        this.addChild(treeElement, false);
    }

    private void addChild(TreeElement treeElement, boolean bl) {
        TreeElement treeElement2;
        if (!this.isChildable()) {
            throw new RuntimeException("Can't add children to node that has data value!");
        }
        if (treeElement.multiplicity == -1) {
            throw new RuntimeException("Cannot add child with an unbound index!");
        }
        if (bl && (treeElement2 = this.getChild(treeElement.name, treeElement.multiplicity)) != null) {
            throw new RuntimeException("Attempted to add duplicate child!");
        }
        int n = this.children.size();
        if (treeElement.getMult() == -2) {
            TreeElement treeElement3 = this.getChild(treeElement.getName(), 0);
            if (treeElement3 != null) {
                n = this.children.indexOf(treeElement3);
            }
        } else {
            TreeElement treeElement4 = this.getChild(treeElement.getName(), treeElement.getMult() == 0 ? -2 : treeElement.getMult() - 1);
            if (treeElement4 != null) {
                n = this.children.indexOf(treeElement4) + 1;
            }
        }
        this.children.insertElementAt(treeElement, n);
        treeElement.setParent(this);
        treeElement.setRelevant(this.isRelevant(), true);
        treeElement.setEnabled(this.isEnabled(), true);
    }

    public void removeChild(TreeElement treeElement) {
        this.children.removeElement(treeElement);
    }

    public void removeChild(String string, int n) {
        TreeElement treeElement = this.getChild(string, n);
        if (treeElement != null) {
            this.removeChild(treeElement);
        }
    }

    public void removeChildren(String string) {
        this.removeChildren(string, false);
    }

    public void removeChildren(String string, boolean bl) {
        Vector<TreeElement> vector = this.getChildrenWithName(string, bl);
        for (int i = 0; i < vector.size(); ++i) {
            this.removeChild(vector.elementAt(i));
        }
    }

    public void removeChildAt(int n) {
        this.children.removeElementAt(n);
    }

    public int getChildMultiplicity(String string) {
        return this.getChildrenWithName(string, false).size();
    }

    public TreeElement shallowCopy() {
        TreeElement treeElement = new TreeElement(this.name, this.multiplicity);
        treeElement.parent = this.parent;
        treeElement.repeatable = this.repeatable;
        treeElement.dataType = this.dataType;
        treeElement.relevant = this.relevant;
        treeElement.required = this.required;
        treeElement.enabled = this.enabled;
        treeElement.constraint = this.constraint;
        treeElement.preloadHandler = this.preloadHandler;
        treeElement.preloadParams = this.preloadParams;
        treeElement.setAttributesFromSingleStringVector(this.getSingleStringAttributeVector());
        if (this.value != null) {
            treeElement.value = this.value.clone();
        }
        treeElement.children = this.children;
        return treeElement;
    }

    public TreeElement deepCopy(boolean bl) {
        TreeElement treeElement = this.shallowCopy();
        treeElement.children = new Vector();
        for (int i = 0; i < this.children.size(); ++i) {
            TreeElement treeElement2 = (TreeElement)this.children.elementAt(i);
            if (!bl && treeElement2.getMult() == -2) continue;
            treeElement.addChild(treeElement2.deepCopy(bl));
        }
        return treeElement;
    }

    public boolean isRelevant() {
        return this.relevantInherited && this.relevant;
    }

    public boolean isEnabled() {
        return this.enabledInherited && this.enabled;
    }

    public boolean setAnswer(IAnswerData iAnswerData) {
        if (this.value != null || iAnswerData != null) {
            this.setValue(iAnswerData);
            this.alertStateObservers(1);
            return true;
        }
        return false;
    }

    public void setRequired(boolean bl) {
        if (this.required != bl) {
            this.required = bl;
            this.alertStateObservers(16);
        }
    }

    public void setRelevant(boolean bl) {
        this.setRelevant(bl, false);
    }

    private void setRelevant(boolean bl, boolean bl2) {
        boolean bl3 = this.isRelevant();
        if (bl2) {
            this.relevantInherited = bl;
        } else {
            this.relevant = bl;
        }
        if (this.isRelevant() != bl3) {
            int n;
            for (n = 0; n < this.children.size(); ++n) {
                ((TreeElement)this.children.elementAt(n)).setRelevant(this.isRelevant(), true);
            }
            for (n = 0; n < this.attributes.size(); ++n) {
                this.attributes.elementAt(n).setRelevant(this.isRelevant(), true);
            }
            this.alertStateObservers(8);
        }
    }

    public void setEnabled(boolean bl) {
        this.setEnabled(bl, false);
    }

    public void setEnabled(boolean bl, boolean bl2) {
        boolean bl3 = this.isEnabled();
        if (bl2) {
            this.enabledInherited = bl;
        } else {
            this.enabled = bl;
        }
        if (this.isEnabled() != bl3) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((TreeElement)this.children.elementAt(i)).setEnabled(this.isEnabled(), true);
            }
            this.alertStateObservers(4);
        }
    }

    public void registerStateObserver(FormElementStateListener formElementStateListener) {
        if (this.observers == null) {
            this.observers = new Vector();
        }
        if (!this.observers.contains(formElementStateListener)) {
            this.observers.addElement(formElementStateListener);
        }
    }

    public void unregisterStateObserver(FormElementStateListener formElementStateListener) {
        if (this.observers != null) {
            this.observers.removeElement(formElementStateListener);
            if (this.observers.isEmpty()) {
                this.observers = null;
            }
        }
    }

    public void unregisterAll() {
        this.observers = null;
    }

    public void alertStateObservers(int n) {
        if (this.observers != null) {
            Enumeration enumeration = this.observers.elements();
            while (enumeration.hasMoreElements()) {
                ((FormElementStateListener)enumeration.nextElement()).formElementStateChanged(this, n);
            }
        }
    }

    public void accept(ITreeVisitor iTreeVisitor) {
        iTreeVisitor.visit(this);
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((TreeElement)enumeration.nextElement()).accept(iTreeVisitor);
        }
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String getAttributeNamespace(int n) {
        return this.attributes.elementAt((int)n).namespace;
    }

    public String getAttributeName(int n) {
        return this.attributes.elementAt((int)n).name;
    }

    public String getAttributeValue(int n) {
        return this.getAttributeValue(this.attributes.elementAt(n));
    }

    private String getAttributeValue(TreeElement treeElement) {
        if (treeElement.getValue() == null) {
            return null;
        }
        return treeElement.getValue().uncast().getString();
    }

    public TreeElement getAttribute(String string, String string2) {
        for (TreeElement treeElement : this.attributes) {
            if (!treeElement.getName().equals(string2) || string != null && !string.equals(treeElement.namespace)) continue;
            return treeElement;
        }
        return null;
    }

    public String getAttributeValue(String string, String string2) {
        TreeElement treeElement = this.getAttribute(string, string2);
        return treeElement == null ? null : this.getAttributeValue(treeElement);
    }

    public void setAttribute(String string, String string2, String string3) {
        for (int i = this.attributes.size() - 1; i >= 0; --i) {
            TreeElement treeElement = this.attributes.elementAt(i);
            if (!treeElement.name.equals(string2) || string != null && !string.equals(treeElement.namespace)) continue;
            if (string3 == null) {
                this.attributes.removeElementAt(i);
            } else {
                treeElement.setValue(new UncastData(string3));
            }
            return;
        }
        if (string == null) {
            string = "";
        }
        TreeElement treeElement = TreeElement.constructAttributeElement(string, string2);
        treeElement.setValue(new UncastData(string3));
        treeElement.setParent(this);
        this.attributes.addElement(treeElement);
    }

    public Vector getSingleStringAttributeVector() {
        Vector<String> vector = new Vector<String>();
        if (this.attributes.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            TreeElement treeElement = this.attributes.elementAt(i);
            String string = this.getAttributeValue(treeElement);
            if (treeElement.namespace == null || treeElement.namespace == "") {
                vector.addElement(new String(treeElement.getName() + "=" + string));
                continue;
            }
            vector.addElement(new String(treeElement.namespace + ":" + treeElement.getName() + "=" + string));
        }
        return vector;
    }

    public void setAttributesFromSingleStringVector(Vector vector) {
        this.attributes = new Vector(0);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.addSingleAttribute(i, vector);
            }
        }
    }

    private void addSingleAttribute(int n, Vector vector) {
        String string = (String)vector.elementAt(n);
        String[] stringArray = new String[3];
        int n2 = 0;
        int n3 = -1;
        while (string.indexOf(":", n3 + 1) != -1) {
            n3 = string.indexOf(":", n3 + 1);
        }
        if (n3 == -1) {
            stringArray[0] = null;
            n2 = 0;
        } else {
            stringArray[0] = string.substring(n2, n3);
            n2 = ++n3;
        }
        n3 = string.indexOf("=");
        stringArray[1] = string.substring(n2, n3);
        n2 = ++n3;
        stringArray[2] = string.substring(n2);
        this.setAttribute(stringArray[0], stringArray[1], stringArray[2]);
    }

    @Override
    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.name = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.multiplicity = ExtUtil.readInt(dataInputStream);
        this.repeatable = ExtUtil.readBool(dataInputStream);
        this.value = (IAnswerData)ExtUtil.read(dataInputStream, new ExtWrapNullable(new ExtWrapTagged()), prototypeFactory);
        if (!ExtUtil.readBool(dataInputStream)) {
            this.children = null;
        } else {
            this.children = new Vector();
            int n = (int)ExtUtil.readNumeric(dataInputStream);
            for (int i = 0; i < n; ++i) {
                TreeElement treeElement;
                boolean bl = ExtUtil.readBool(dataInputStream);
                if (bl) {
                    treeElement = new TreeElement();
                    treeElement.readExternal(dataInputStream, prototypeFactory);
                } else {
                    treeElement = (TreeElement)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
                }
                treeElement.setParent(this);
                this.children.addElement(treeElement);
            }
        }
        this.dataType = ExtUtil.readInt(dataInputStream);
        this.relevant = ExtUtil.readBool(dataInputStream);
        this.required = ExtUtil.readBool(dataInputStream);
        this.enabled = ExtUtil.readBool(dataInputStream);
        this.relevantInherited = ExtUtil.readBool(dataInputStream);
        this.enabledInherited = ExtUtil.readBool(dataInputStream);
        this.constraint = (Constraint)ExtUtil.read(dataInputStream, new ExtWrapNullable(Constraint.class), prototypeFactory);
        this.preloadHandler = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        this.preloadParams = ExtUtil.nullIfEmpty(ExtUtil.readString(dataInputStream));
        Vector vector = ExtUtil.nullIfEmpty((Vector)ExtUtil.read(dataInputStream, new ExtWrapList(String.class), prototypeFactory));
        this.setAttributesFromSingleStringVector(vector);
    }

    @Override
    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.name));
        ExtUtil.writeNumeric(dataOutputStream, this.multiplicity);
        ExtUtil.writeBool(dataOutputStream, this.repeatable);
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.value == null ? null : new ExtWrapTagged(this.value)));
        if (this.children == null) {
            ExtUtil.writeBool(dataOutputStream, false);
        } else {
            ExtUtil.writeBool(dataOutputStream, true);
            ExtUtil.writeNumeric(dataOutputStream, this.children.size());
            object = this.children.elements();
            while (object.hasMoreElements()) {
                TreeElement treeElement = (TreeElement)object.nextElement();
                if (treeElement.getClass() == TreeElement.class) {
                    ExtUtil.writeBool(dataOutputStream, true);
                    treeElement.writeExternal(dataOutputStream);
                    continue;
                }
                ExtUtil.writeBool(dataOutputStream, false);
                ExtUtil.write(dataOutputStream, new ExtWrapTagged(treeElement));
            }
        }
        ExtUtil.writeNumeric(dataOutputStream, this.dataType);
        ExtUtil.writeBool(dataOutputStream, this.relevant);
        ExtUtil.writeBool(dataOutputStream, this.required);
        ExtUtil.writeBool(dataOutputStream, this.enabled);
        ExtUtil.writeBool(dataOutputStream, this.relevantInherited);
        ExtUtil.writeBool(dataOutputStream, this.enabledInherited);
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.constraint));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.preloadHandler));
        ExtUtil.writeString(dataOutputStream, ExtUtil.emptyIfNull(this.preloadParams));
        object = this.getSingleStringAttributeVector();
        ExtUtil.write(dataOutputStream, new ExtWrapList(ExtUtil.emptyIfNull((Vector)object)));
    }

    public void populate(TreeElement treeElement, FormDef formDef) {
        if (this.isLeaf()) {
            IAnswerData iAnswerData = treeElement.getValue();
            if (iAnswerData == null) {
                this.setValue(null);
            } else if (this.dataType == 1 || this.dataType == 0) {
                this.setValue(iAnswerData);
            } else {
                String string = (String)iAnswerData.getValue();
                IAnswerData iAnswerData2 = RestoreUtils.xfFact.parseData(string, this.dataType, this.getRef(), formDef);
                this.setValue(iAnswerData2);
            }
        } else {
            Object object;
            TreeElement treeElement2;
            int n;
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < this.getNumChildren(); ++n) {
                treeElement2 = this.getChildAt(n);
                if (vector.contains(treeElement2.getName())) continue;
                vector.addElement(treeElement2.getName());
            }
            for (n = 0; n < this.getNumChildren(); ++n) {
                treeElement2 = this.getChildAt(n);
                if (!treeElement2.repeatable || treeElement2.getMult() == -2) continue;
                this.removeChildAt(n);
                --n;
            }
            if (this.getNumChildren() != vector.size()) {
                throw new RuntimeException("sanity check failed");
            }
            for (n = 0; n < this.getNumChildren(); ++n) {
                int n2;
                treeElement2 = this.getChildAt(n);
                object = (String)vector.elementAt(n);
                if (treeElement2.getName().equals(object)) continue;
                TreeElement treeElement3 = null;
                for (n2 = n + 1; n2 < this.getNumChildren() && !(treeElement3 = this.getChildAt(n2)).getName().equals(object); ++n2) {
                }
                if (n2 == this.getNumChildren()) {
                    throw new RuntimeException("sanity check failed");
                }
                this.removeChildAt(n2);
                this.children.insertElementAt(treeElement3, n);
            }
            for (n = 0; n < this.getNumChildren(); ++n) {
                treeElement2 = this.getChildAt(n);
                object = treeElement.getChildrenWithName(treeElement2.getName());
                if (treeElement2.repeatable) {
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        TreeElement treeElement4 = treeElement2.deepCopy(true);
                        treeElement4.setMult(i);
                        this.children.insertElementAt(treeElement4, n + i + 1);
                        treeElement4.populate((TreeElement)((Vector)object).elementAt(i), formDef);
                    }
                    n += ((Vector)object).size();
                    continue;
                }
                if (((Vector)object).size() == 0) {
                    treeElement2.setRelevant(false);
                    continue;
                }
                treeElement2.populate((TreeElement)((Vector)object).elementAt(0), formDef);
            }
        }
    }

    public void populateTemplate(TreeElement treeElement, FormDef formDef) {
        if (this.isLeaf()) {
            IAnswerData iAnswerData = treeElement.getValue();
            if (iAnswerData == null) {
                this.setValue(null);
            } else {
                Class clazz = CompactInstanceWrapper.classForDataType(this.dataType);
                if (clazz == null) {
                    throw new RuntimeException("data type [" + iAnswerData.getClass().getName() + "] not supported inside itemset");
                }
                if (clazz.isAssignableFrom(iAnswerData.getClass()) && !(iAnswerData instanceof SelectOneData) && !(iAnswerData instanceof SelectMultiData)) {
                    this.setValue(iAnswerData);
                } else {
                    String string = RestoreUtils.xfFact.serializeData(iAnswerData);
                    IAnswerData iAnswerData2 = RestoreUtils.xfFact.parseData(string, this.dataType, this.getRef(), formDef);
                    this.setValue(iAnswerData2);
                }
            }
        } else {
            for (int i = 0; i < this.getNumChildren(); ++i) {
                TreeElement treeElement2 = this.getChildAt(i);
                Vector<TreeElement> vector = treeElement.getChildrenWithName(treeElement2.getName());
                if (treeElement2.repeatable) {
                    for (int j = 0; j < vector.size(); ++j) {
                        TreeElement treeElement3 = formDef.getInstance().getTemplate(treeElement2.getRef());
                        TreeElement treeElement4 = treeElement3.deepCopy(false);
                        treeElement4.setMult(j);
                        this.children.insertElementAt(treeElement4, i + j + 1);
                        treeElement4.populateTemplate(vector.elementAt(j), formDef);
                    }
                    i += vector.size();
                    continue;
                }
                treeElement2.populateTemplate(vector.elementAt(0), formDef);
            }
        }
    }

    public TreeReference getRef() {
        TreeElement treeElement = this;
        TreeReference treeReference = TreeReference.selfRef();
        while (treeElement != null) {
            TreeReference treeReference2;
            if (treeElement.name != null) {
                treeReference2 = TreeReference.selfRef();
                treeReference2.add(treeElement.name, treeElement.multiplicity);
            } else {
                treeReference2 = TreeReference.rootRef();
            }
            treeReference = treeReference.parent(treeReference2);
            treeElement = treeElement.parent;
        }
        return treeReference;
    }

    public int getDepth() {
        TreeElement treeElement = this;
        int n = 0;
        while (treeElement.name != null) {
            ++n;
            treeElement = treeElement.parent;
        }
        return n;
    }

    public String getPreloadHandler() {
        return this.preloadHandler;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setPreloadHandler(String string) {
        this.preloadHandler = string;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public String getPreloadParams() {
        return this.preloadParams;
    }

    public void setPreloadParams(String string) {
        this.preloadParams = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getMult() {
        return this.multiplicity;
    }

    public void setMult(int n) {
        this.multiplicity = n;
    }

    public void setParent(TreeElement treeElement) {
        this.parent = treeElement;
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public IAnswerData getValue() {
        return this.value;
    }
}

