/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.util.restorable;

import java.util.Date;
import java.util.Vector;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.IRecordFilter;
import org.javarosa.core.model.util.restorable.IXFormyFactory;
import org.javarosa.core.model.util.restorable.Restorable;
import org.javarosa.core.services.storage.IStorageIterator;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class RestoreUtils {
    public static final String RECORD_ID_TAG = "rec-id";
    public static IXFormyFactory xfFact;

    public static TreeReference ref(String string) {
        return xfFact.ref(string);
    }

    public static TreeReference absRef(String string, FormInstance formInstance) {
        TreeReference treeReference = RestoreUtils.ref(string);
        if (!treeReference.isAbsolute()) {
            treeReference = treeReference.parent(RestoreUtils.topRef(formInstance));
        }
        return treeReference;
    }

    public static TreeReference topRef(FormInstance formInstance) {
        return RestoreUtils.ref("/" + formInstance.getRoot().getName());
    }

    public static TreeReference childRef(String string, TreeReference treeReference) {
        return RestoreUtils.ref(string).parent(treeReference);
    }

    private static FormInstance newDataModel(String string) {
        FormInstance formInstance = new FormInstance();
        formInstance.addNode(RestoreUtils.ref("/" + string));
        return formInstance;
    }

    public static FormInstance createDataModel(Restorable restorable) {
        FormInstance formInstance = RestoreUtils.newDataModel(restorable.getRestorableType());
        if (restorable instanceof Persistable) {
            RestoreUtils.addData(formInstance, RECORD_ID_TAG, new Integer(((Persistable)((Object)restorable)).getID()));
        }
        return formInstance;
    }

    public static FormInstance createRootDataModel(Restorable restorable) {
        FormInstance formInstance = RestoreUtils.createDataModel(restorable);
        formInstance.schema = "http://openrosa.org/backup";
        RestoreUtils.addData(formInstance, "timestamp", new Date(), 6);
        return formInstance;
    }

    public static void addData(FormInstance formInstance, String string, Object object) {
        RestoreUtils.addData(formInstance, string, object, RestoreUtils.getDataType(object));
    }

    public static void addData(FormInstance formInstance, String string, Object object, int n) {
        IAnswerData iAnswerData;
        if (object == null) {
            n = -1;
        }
        switch (n) {
            case -1: {
                iAnswerData = null;
                break;
            }
            case 1: {
                iAnswerData = new StringData((String)object);
                break;
            }
            case 2: {
                iAnswerData = new IntegerData((Integer)object);
                break;
            }
            case 3: {
                iAnswerData = new DecimalData((Double)object);
                break;
            }
            case 9: {
                iAnswerData = new StringData((Boolean)object != false ? "t" : "f");
                break;
            }
            case 4: {
                iAnswerData = new DateData((Date)object);
                break;
            }
            case 6: {
                iAnswerData = new DateTimeData((Date)object);
                break;
            }
            case 5: {
                iAnswerData = new TimeData((Date)object);
                break;
            }
            case 8: {
                iAnswerData = (SelectMultiData)object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to handle data type [" + n + "]");
            }
        }
        TreeReference treeReference = RestoreUtils.absRef(string, formInstance);
        if (formInstance.addNode(treeReference, iAnswerData, n) == null) {
            throw new RuntimeException("error setting value during object backup [" + string + "]");
        }
    }

    public static int getDataType(Object object) {
        int n = -1;
        if (object instanceof String) {
            n = 1;
        } else if (object instanceof Integer || object instanceof Long) {
            n = 2;
        } else if (object instanceof Float || object instanceof Double) {
            n = 3;
        } else if (object instanceof Date) {
            n = 4;
        } else if (object instanceof Boolean) {
            n = 9;
        } else if (object instanceof SelectMultiData) {
            n = 8;
        }
        return n;
    }

    public static int getDataType(Class clazz) {
        int n;
        if (clazz == String.class) {
            n = 1;
        } else if (clazz == Integer.class || clazz == Long.class) {
            n = 2;
        } else if (clazz == Float.class || clazz == Double.class) {
            n = 3;
        } else if (clazz == Date.class) {
            n = 4;
        } else if (clazz == Boolean.class) {
            n = 1;
        } else {
            throw new RuntimeException("Can't handle data type " + clazz.getName());
        }
        return n;
    }

    public static Object getValue(String string, FormInstance formInstance) {
        return RestoreUtils.getValue(string, RestoreUtils.topRef(formInstance), formInstance);
    }

    public static Object getValue(String string, TreeReference treeReference, FormInstance formInstance) {
        TreeElement treeElement = formInstance.resolveReference(RestoreUtils.ref(string).contextualize(treeReference));
        if (treeElement == null) {
            throw new RuntimeException("Could not find node [" + string + "] when parsing saved instance!");
        }
        if (treeElement.isRelevant()) {
            IAnswerData iAnswerData = treeElement.getValue();
            return iAnswerData == null ? null : iAnswerData.getValue();
        }
        return null;
    }

    public static void applyDataType(FormInstance formInstance, String string, TreeReference treeReference, Class clazz) {
        RestoreUtils.applyDataType(formInstance, string, treeReference, RestoreUtils.getDataType(clazz));
    }

    public static void applyDataType(FormInstance formInstance, String string, TreeReference treeReference, int n) {
        TreeReference treeReference2 = RestoreUtils.childRef(string, treeReference);
        Vector vector = formInstance.expandReference(treeReference2);
        for (int i = 0; i < vector.size(); ++i) {
            TreeElement treeElement = formInstance.resolveReference((TreeReference)vector.elementAt(i));
            treeElement.dataType = n;
        }
    }

    public static void templateChild(FormInstance formInstance, String string, TreeReference treeReference, Restorable restorable) {
        TreeReference treeReference2 = string == null ? treeReference : RestoreUtils.childRef(string, treeReference);
        treeReference2 = RestoreUtils.childRef(restorable.getRestorableType(), treeReference2);
        RestoreUtils.templateData(restorable, formInstance, treeReference2);
    }

    public static void templateData(Restorable restorable, FormInstance formInstance, TreeReference treeReference) {
        if (treeReference == null) {
            treeReference = RestoreUtils.topRef(formInstance);
            RestoreUtils.applyDataType(formInstance, "timestamp", treeReference, Date.class);
        }
        if (restorable instanceof Persistable) {
            RestoreUtils.applyDataType(formInstance, RECORD_ID_TAG, treeReference, Integer.class);
        }
        restorable.templateData(formInstance, treeReference);
    }

    public static void mergeDataModel(FormInstance formInstance, FormInstance formInstance2, String string) {
        RestoreUtils.mergeDataModel(formInstance, formInstance2, RestoreUtils.absRef(string, formInstance));
    }

    public static void mergeDataModel(FormInstance formInstance, FormInstance formInstance2, TreeReference treeReference) {
        TreeElement treeElement = formInstance.resolveReference(treeReference);
        if (treeElement == null) {
            treeReference = formInstance.addNode(treeReference);
            treeElement = formInstance.resolveReference(treeReference);
        }
        TreeElement treeElement2 = formInstance2.getRoot();
        int n = treeElement.getChildMultiplicity(treeElement2.getName());
        treeElement2.setMult(n);
        treeElement.addChild(treeElement2);
    }

    public static FormInstance exportRMS(IStorageUtility iStorageUtility, Class clazz, String string, IRecordFilter iRecordFilter) {
        if (!Externalizable.class.isAssignableFrom(clazz) || !Restorable.class.isAssignableFrom(clazz)) {
            return null;
        }
        FormInstance formInstance = RestoreUtils.newDataModel(string);
        IStorageIterator iStorageIterator = iStorageUtility.iterate();
        while (iStorageIterator.hasMore()) {
            Externalizable externalizable = iStorageIterator.nextRecord();
            if (iRecordFilter != null && !iRecordFilter.filter(externalizable)) continue;
            FormInstance formInstance2 = ((Restorable)((Object)externalizable)).exportData();
            RestoreUtils.mergeDataModel(formInstance, formInstance2, RestoreUtils.topRef(formInstance));
        }
        return formInstance;
    }

    public static FormInstance subDataModel(TreeElement treeElement) {
        TreeElement treeElement2 = treeElement.shallowCopy();
        treeElement2.setMult(0);
        return new FormInstance(treeElement2);
    }

    public static void exportRMS(FormInstance formInstance, Class clazz, String string, IStorageUtility iStorageUtility, IRecordFilter iRecordFilter) {
        FormInstance formInstance2 = RestoreUtils.exportRMS(iStorageUtility, clazz, string, iRecordFilter);
        RestoreUtils.mergeDataModel(formInstance, formInstance2, ".");
    }

    public static void importRMS(FormInstance formInstance, IStorageUtility iStorageUtility, Class clazz, String string) {
        if (!Externalizable.class.isAssignableFrom(clazz) || !Restorable.class.isAssignableFrom(clazz)) {
            return;
        }
        boolean bl = Persistable.class.isAssignableFrom(clazz);
        String string2 = ((Restorable)PrototypeFactory.getInstance(clazz)).getRestorableType();
        TreeElement treeElement = formInstance.resolveReference(RestoreUtils.absRef(string, formInstance));
        Vector<TreeElement> vector = treeElement.getChildrenWithName(string2);
        for (int i = 0; i < vector.size(); ++i) {
            FormInstance formInstance2 = RestoreUtils.subDataModel(vector.elementAt(i));
            Restorable restorable = (Restorable)PrototypeFactory.getInstance(clazz);
            int n = -1;
            if (bl) {
                n = (Integer)RestoreUtils.getValue(RECORD_ID_TAG, formInstance2);
                ((Persistable)((Object)restorable)).setID(n);
            }
            restorable.importData(formInstance2);
            try {
                if (bl) {
                    iStorageUtility.write((Persistable)((Object)restorable));
                    continue;
                }
                iStorageUtility.add((Externalizable)((Object)restorable));
                continue;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error importing RMS during restore! [" + clazz.getName() + ":" + n + "]; " + exception.getMessage());
            }
        }
    }

    public static ByteArrayPayload dispatch(FormInstance formInstance) {
        return (ByteArrayPayload)xfFact.serializeInstance(formInstance);
    }

    public static FormInstance receive(byte[] byArray, Class clazz) {
        return xfFact.parseRestore(byArray, clazz);
    }

    public static boolean getBoolean(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if ("t".equals(string)) {
                return true;
            }
            if ("f".equals(string)) {
                return false;
            }
            throw new RuntimeException("boolean string must be t or f");
        }
        throw new RuntimeException("booleans are encoded as strings");
    }
}

