/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.utils;

import java.util.Date;
import java.util.Vector;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.model.utils.IPreloadHandler;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.util.Map;
import org.javarosa.core.util.PropertyUtils;

public class QuestionPreloader {
    private Map preloadHandlers = new Map();

    public QuestionPreloader() {
        this.initPreloadHandlers();
    }

    private void initPreloadHandlers() {
        IPreloadHandler iPreloadHandler = new IPreloadHandler(){

            public String preloadHandled() {
                return "date";
            }

            public IAnswerData handlePreload(String string) {
                return QuestionPreloader.this.preloadDate(string);
            }

            public boolean handlePostProcess(TreeElement treeElement, String string) {
                return false;
            }
        };
        IPreloadHandler iPreloadHandler2 = new IPreloadHandler(){

            public String preloadHandled() {
                return "property";
            }

            public IAnswerData handlePreload(String string) {
                return QuestionPreloader.this.preloadProperty(string);
            }

            public boolean handlePostProcess(TreeElement treeElement, String string) {
                QuestionPreloader.this.saveProperty(string, treeElement);
                return false;
            }
        };
        IPreloadHandler iPreloadHandler3 = new IPreloadHandler(){

            public String preloadHandled() {
                return "timestamp";
            }

            public IAnswerData handlePreload(String string) {
                return "start".equals(string) ? QuestionPreloader.this.getTimestamp() : null;
            }

            public boolean handlePostProcess(TreeElement treeElement, String string) {
                if ("end".equals(string)) {
                    treeElement.setAnswer(QuestionPreloader.this.getTimestamp());
                    return true;
                }
                return false;
            }
        };
        IPreloadHandler iPreloadHandler4 = new IPreloadHandler(){

            public String preloadHandled() {
                return "uid";
            }

            public IAnswerData handlePreload(String string) {
                return new StringData(PropertyUtils.genGUID(25));
            }

            public boolean handlePostProcess(TreeElement treeElement, String string) {
                return false;
            }
        };
        this.addPreloadHandler(iPreloadHandler);
        this.addPreloadHandler(iPreloadHandler2);
        this.addPreloadHandler(iPreloadHandler3);
        this.addPreloadHandler(iPreloadHandler4);
    }

    public void addPreloadHandler(IPreloadHandler iPreloadHandler) {
        this.preloadHandlers.put(iPreloadHandler.preloadHandled(), iPreloadHandler);
    }

    public IAnswerData getQuestionPreload(String string, String string2) {
        IPreloadHandler iPreloadHandler = (IPreloadHandler)this.preloadHandlers.get(string);
        if (iPreloadHandler != null) {
            return iPreloadHandler.handlePreload(string2);
        }
        System.err.println("Do not know how to handle preloader [" + string + "]");
        return null;
    }

    public boolean questionPostProcess(TreeElement treeElement, String string, String string2) {
        IPreloadHandler iPreloadHandler = (IPreloadHandler)this.preloadHandlers.get(string);
        if (iPreloadHandler != null) {
            return iPreloadHandler.handlePostProcess(treeElement, string2);
        }
        System.err.println("Do not know how to handle preloader [" + string + "]");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAnswerData preloadDate(String string) {
        Date date = null;
        if (string.equals("today")) {
            date = new Date();
            return new DateData(date);
        }
        if (!string.substring(0, 11).equals("prevperiod-")) return new DateData(date);
        Vector vector = DateUtils.split(string.substring(11), "-", false);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        try {
            boolean bl;
            boolean bl2;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (stringArray[2].equals("head")) {
                bl2 = true;
            } else {
                if (!stringArray[2].equals("tail")) throw new RuntimeException();
                bl2 = false;
            }
            if (stringArray.length >= 4) {
                if (stringArray[3].equals("x")) {
                    bl = true;
                } else {
                    if (!stringArray[3].equals("")) throw new RuntimeException();
                    bl = false;
                }
            } else {
                bl = false;
            }
            int n = stringArray.length >= 5 ? Integer.parseInt(stringArray[4]) : 1;
            date = DateUtils.getPastPeriodDate(new Date(), string2, string3, bl2, bl, n);
            return new DateData(date);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("invalid preload params for preload mode 'date'");
        }
    }

    private IAnswerData preloadProperty(String string) {
        String string2 = string;
        String string3 = PropertyManager._().getSingularProperty(string2);
        StringData stringData = null;
        if (string3 != null && string3.length() > 0) {
            stringData = new StringData(string3);
        }
        return stringData;
    }

    private void saveProperty(String string, TreeElement treeElement) {
        String string2;
        IAnswerData iAnswerData = treeElement.getValue();
        String string3 = string2 = iAnswerData == null ? null : iAnswerData.getDisplayText();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            PropertyManager._().setProperty(string, string2);
        }
    }

    private DateTimeData getTimestamp() {
        return new DateTimeData(new Date());
    }
}

