/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.ReferenceManager;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.services.locale.LocalizationUtils;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ReferenceDataSource
implements LocaleDataSource {
    String referenceURI;

    public ReferenceDataSource() {
    }

    public ReferenceDataSource(String string) {
        if (string == null) {
            throw new NullPointerException("Reference URI cannot be null when creating a Resource File Data Source");
        }
        this.referenceURI = string;
    }

    public OrderedHashtable getLocalizedText() {
        try {
            InputStream inputStream = ReferenceManager._().DeriveReference(this.referenceURI).getStream();
            return LocalizationUtils.parseLocaleInput(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("IOException while getting localized text at reference " + this.referenceURI);
        }
        catch (InvalidReferenceException invalidReferenceException) {
            invalidReferenceException.printStackTrace();
            throw new RuntimeException("Invalid Reference! " + this.referenceURI);
        }
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.referenceURI = dataInputStream.readUTF();
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.referenceURI);
    }
}

