/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.util.Vector;
import org.javarosa.core.reference.InvalidReferenceException;
import org.javarosa.core.reference.Reference;
import org.javarosa.core.reference.ReferenceFactory;
import org.javarosa.core.reference.RootTranslator;

public class ReferenceManager {
    private static ReferenceManager instance;
    private Vector<RootTranslator> translators = new Vector();
    private Vector<ReferenceFactory> factories = new Vector();
    private Vector<RootTranslator> sessionTranslators = new Vector();

    private ReferenceManager() {
    }

    public static ReferenceManager _() {
        if (instance == null) {
            instance = new ReferenceManager();
        }
        return instance;
    }

    public ReferenceFactory[] getFactories() {
        Object[] objectArray = new ReferenceFactory[this.translators.size()];
        this.translators.copyInto(objectArray);
        return objectArray;
    }

    public void addRootTranslator(RootTranslator rootTranslator) {
        if (!this.translators.contains(rootTranslator)) {
            this.translators.addElement(rootTranslator);
        }
    }

    public void addReferenceFactory(ReferenceFactory referenceFactory) {
        if (!this.factories.contains(referenceFactory)) {
            this.factories.addElement(referenceFactory);
        }
    }

    public boolean removeReferenceFactory(ReferenceFactory referenceFactory) {
        return this.factories.removeElement(referenceFactory);
    }

    public Reference DeriveReference(String string) throws InvalidReferenceException {
        return this.DeriveReference(string, (String)null);
    }

    public Reference DeriveReference(String string, Reference reference) throws InvalidReferenceException {
        return this.DeriveReference(string, reference.getURI());
    }

    public Reference DeriveReference(String string, String string2) throws InvalidReferenceException {
        if (ReferenceManager.isRelative(string)) {
            if (string.startsWith("./")) {
                string = string.substring(2);
            }
            if (string2 == null) {
                throw new RuntimeException("Attempted to retrieve local reference with no context");
            }
            return this.derivingRoot(string2).derive(string, string2);
        }
        return this.derivingRoot(string).derive(string);
    }

    public void addSessionRootTranslator(RootTranslator rootTranslator) {
        this.sessionTranslators.addElement(rootTranslator);
    }

    public void clearSession() {
        this.sessionTranslators.removeAllElements();
    }

    private ReferenceFactory derivingRoot(String string) throws InvalidReferenceException {
        for (RootTranslator referenceFactory : this.sessionTranslators) {
            if (!referenceFactory.derives(string)) continue;
            return referenceFactory;
        }
        for (RootTranslator rootTranslator : this.translators) {
            if (!rootTranslator.derives(string)) continue;
            return rootTranslator;
        }
        for (ReferenceFactory referenceFactory : this.factories) {
            if (!referenceFactory.derives(string)) continue;
            return referenceFactory;
        }
        throw new InvalidReferenceException("No reference could be created for URI " + string, string);
    }

    public static boolean isRelative(String string) {
        return string.startsWith("./");
    }
}

