/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.reference;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.javarosa.core.reference.Reference;

public class ResourceReference
implements Reference {
    String URI;

    public ResourceReference(String string) {
        this.URI = string;
    }

    public boolean doesBinaryExist() throws IOException {
        InputStream inputStream = System.class.getResourceAsStream(this.URI);
        if (inputStream == null) {
            return false;
        }
        inputStream.close();
        return true;
    }

    public InputStream getStream() throws IOException {
        InputStream inputStream = System.class.getResourceAsStream(this.URI);
        return inputStream;
    }

    public String getURI() {
        return "jr://resource" + this.URI;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof ResourceReference) {
            return this.URI.equals(((ResourceReference)object).URI);
        }
        return false;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Resource references are read-only URI's");
    }

    public void remove() throws IOException {
        throw new IOException("Resource references are read-only URI's");
    }

    public String getLocalURI() {
        return this.URI;
    }
}

