/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.locale;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.javarosa.core.services.locale.LocaleDataSource;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ResourceFileDataSource
implements LocaleDataSource {
    String resourceURI;

    public ResourceFileDataSource() {
    }

    public ResourceFileDataSource(String string) {
        if (string == null) {
            throw new NullPointerException("Resource URI cannot be null when creating a Resource File Data Source");
        }
        this.resourceURI = string;
    }

    public OrderedHashtable getLocalizedText() {
        return this.loadLocaleResource(this.resourceURI);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.resourceURI = dataInputStream.readUTF();
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.resourceURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedHashtable loadLocaleResource(String string) {
        InputStreamReader inputStreamReader;
        InputStream inputStream = System.class.getResourceAsStream(string);
        OrderedHashtable orderedHashtable = new OrderedHashtable();
        int n = 100;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load locale resource " + string + ". Is it in the jar?");
        }
        boolean bl = false;
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        try {
            String string2 = "";
            block13: while (!bl) {
                int n4 = inputStreamReader.read(cArray, n2, n - n2);
                if (n4 == -1) {
                    bl = true;
                    if (string2 != "") {
                        this.parseAndAdd(orderedHashtable, string2, n3);
                    }
                    break;
                }
                String string3 = String.valueOf(cArray, n2, n4);
                int n5 = 0;
                while (n5 != -1) {
                    int n6 = string3.indexOf(10, n5);
                    if (n6 == -1) {
                        n6 = string3.indexOf(13, n5);
                    }
                    if (n6 == -1) {
                        string2 = string2 + string3.substring(n5);
                        continue block13;
                    }
                    string2 = string2 + string3.substring(n5, n6);
                    this.parseAndAdd(orderedHashtable, string2, ++n3);
                    string2 = "";
                    n5 = n6 + 1;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Input Stream for resource file " + this.resourceURI + " failed to close. This will eat up your memory! Fix Problem! [" + iOException.getMessage() + "]");
                iOException.printStackTrace();
            }
        }
        return orderedHashtable;
    }

    private void parseAndAdd(OrderedHashtable orderedHashtable, String string, int n) {
        string = string.trim();
        while (string.indexOf("#") != -1) {
            string = string.substring(0, string.indexOf("#"));
        }
        if (string.indexOf(61) == -1) {
            if (!string.trim().equals("")) {
                System.out.println("Invalid line (#" + n + ") read: " + string);
            }
        } else if (string.indexOf(61) != string.length() - 1) {
            String string2 = string.substring(string.indexOf(61) + 1, string.length());
            orderedHashtable.put(string.substring(0, string.indexOf(61)), string2);
        } else {
            System.out.println("Invalid line (#" + n + ") read: '" + string + "'. No value follows the '='.");
        }
    }
}

