/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.properties;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.services.PropertyManager;
import org.javarosa.core.services.locale.Localization;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.services.properties.IPropertyRules;

public class JavaRosaPropertyRules
implements IPropertyRules {
    Hashtable rules = new Hashtable();
    Vector readOnlyProperties = new Vector();
    public static final String DEVICE_ID_PROPERTY = "DeviceID";
    public static final String CURRENT_LOCALE = "cur_locale";
    public static final String LOGS_ENABLED = "logenabled";
    public static final String LOGS_ENABLED_YES = "Enabled";
    public static final String LOGS_ENABLED_NO = "Disabled";

    public JavaRosaPropertyRules() {
        this.rules.put(DEVICE_ID_PROPERTY, new Vector());
        Vector<String> vector = new Vector<String>();
        vector.addElement(LOGS_ENABLED_NO);
        vector.addElement(LOGS_ENABLED_YES);
        this.rules.put(LOGS_ENABLED, vector);
        this.rules.put(CURRENT_LOCALE, new Vector());
        this.readOnlyProperties.addElement(DEVICE_ID_PROPERTY);
    }

    public Vector allowableValues(String string) {
        if (CURRENT_LOCALE.equals(string)) {
            Localizer localizer = Localization.getGlobalLocalizerAdvanced();
            Vector<String> vector = new Vector<String>();
            String[] stringArray = localizer.getAvailableLocales();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
            return vector;
        }
        return (Vector)this.rules.get(string);
    }

    public boolean checkValueAllowed(String string, String string2) {
        if (CURRENT_LOCALE.equals(string)) {
            return Localization.getGlobalLocalizerAdvanced().hasLocale(string2);
        }
        Vector vector = (Vector)this.rules.get(string);
        if (vector.size() != 0) {
            if (vector.size() == 1 && this.checkPropertyAllowed((String)vector.elementAt(0))) {
                return PropertyManager._().getProperty((String)vector.elementAt(0)).contains(string2);
            }
            return ((Vector)this.rules.get(string)).contains(string2);
        }
        return true;
    }

    public Vector allowableProperties() {
        Vector vector = new Vector();
        Enumeration enumeration = this.rules.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public boolean checkPropertyAllowed(String string) {
        Enumeration enumeration = this.rules.keys();
        while (enumeration.hasMoreElements()) {
            if (!string.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public boolean checkPropertyUserReadOnly(String string) {
        return this.readOnlyProperties.contains(string);
    }

    public String getHumanReadableDescription(String string) {
        if (DEVICE_ID_PROPERTY.equals(string)) {
            return "Unique Device ID";
        }
        if (LOGS_ENABLED.equals(string)) {
            return "Device Logging";
        }
        if (CURRENT_LOCALE.equals(string)) {
            return Localization.get("settings.language");
        }
        return string;
    }

    public String getHumanReadableValue(String string, String string2) {
        String string3;
        if (CURRENT_LOCALE.equals(string) && (string3 = Localization.getGlobalLocalizerAdvanced().getText(string2)) != null) {
            return string3;
        }
        return string2;
    }

    public void handlePropertyChanges(String string) {
        if (CURRENT_LOCALE.equals(string)) {
            String string2 = PropertyManager._().getSingularProperty(string);
            Localization.setLocale(string2);
        }
    }
}

