/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.storage;

import java.util.NoSuchElementException;
import java.util.Vector;
import org.javarosa.core.services.storage.EntityFilter;
import org.javarosa.core.services.storage.FauxIndexedPersistable;
import org.javarosa.core.services.storage.IMetaData;
import org.javarosa.core.services.storage.IStorageFactory;
import org.javarosa.core.services.storage.IStorageIterator;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.IStorageUtilityIndexed;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.services.storage.StorageFullException;
import org.javarosa.core.util.InvalidIndexException;
import org.javarosa.core.util.externalizable.Externalizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappingStorageUtility
implements IStorageUtilityIndexed {
    IStorageUtility storage;
    SerializationWrapper wrapper;

    public WrappingStorageUtility(String string, SerializationWrapper serializationWrapper, IStorageFactory iStorageFactory) {
        this.storage = iStorageFactory.newStorage(string, serializationWrapper.getClass());
        this.wrapper = serializationWrapper;
    }

    @Override
    public Externalizable read(int n) {
        return ((SerializationWrapper)this.storage.read(n)).getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Persistable persistable) throws StorageFullException {
        SerializationWrapper serializationWrapper = this.wrapper;
        synchronized (serializationWrapper) {
            this.wrapper.setData(persistable);
            if (this.wrapper instanceof IMetaData) {
                this.storage.write(new FauxIndexedPersistable(persistable, this.wrapper, (IMetaData)((Object)this.wrapper)));
            } else {
                this.storage.write(new FauxIndexedPersistable(persistable, this.wrapper));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(Externalizable externalizable) throws StorageFullException {
        SerializationWrapper serializationWrapper = this.wrapper;
        synchronized (serializationWrapper) {
            this.wrapper.setData(externalizable);
            return this.storage.add(this.wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int n, Externalizable externalizable) throws StorageFullException {
        SerializationWrapper serializationWrapper = this.wrapper;
        synchronized (serializationWrapper) {
            this.wrapper.setData(externalizable);
            this.storage.update(n, this.wrapper);
        }
    }

    @Override
    public IStorageIterator iterate() {
        final IStorageIterator iStorageIterator = this.storage.iterate();
        return new IStorageIterator(){

            public boolean hasMore() {
                return iStorageIterator.hasMore();
            }

            public int nextID() {
                return iStorageIterator.nextID();
            }

            public Externalizable nextRecord() {
                return ((SerializationWrapper)iStorageIterator.nextRecord()).getData();
            }

            public int numRecords() {
                return iStorageIterator.numRecords();
            }
        };
    }

    @Override
    public byte[] readBytes(int n) {
        return this.storage.readBytes(n);
    }

    @Override
    public void remove(int n) {
        this.storage.remove(n);
    }

    @Override
    public void remove(Persistable persistable) {
        this.storage.remove(persistable);
    }

    @Override
    public void removeAll() {
        this.storage.removeAll();
    }

    @Override
    public Vector<Integer> removeAll(EntityFilter entityFilter) {
        return this.storage.removeAll(entityFilter);
    }

    @Override
    public boolean exists(int n) {
        return this.storage.exists(n);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public int getNumRecords() {
        return this.storage.getNumRecords();
    }

    @Override
    public int getRecordSize(int n) {
        return this.storage.getRecordSize(n);
    }

    @Override
    public int getTotalSize() {
        return this.storage.getTotalSize();
    }

    @Override
    public void close() {
        this.storage.close();
    }

    @Override
    public void destroy() {
        this.storage.destroy();
    }

    @Override
    public void repack() {
        this.storage.repack();
    }

    @Override
    public void repair() {
        this.storage.repair();
    }

    @Override
    public Object getAccessLock() {
        return this.storage.getAccessLock();
    }

    @Override
    public Vector getIDsForValue(String string, Object object) {
        return this.indexedStorage().getIDsForValue(string, object);
    }

    @Override
    public Externalizable getRecordForValue(String string, Object object) throws NoSuchElementException, InvalidIndexException {
        return ((SerializationWrapper)this.indexedStorage().getRecordForValue(string, object)).getData();
    }

    private IStorageUtilityIndexed indexedStorage() {
        if (!(this.storage instanceof IStorageUtilityIndexed)) {
            throw new RuntimeException("WrappingStorageUtility's factory is not of an indexed type, but had indexed operations requested. Please implement storage " + this.storage.getClass().getName() + " as indexed storage");
        }
        return (IStorageUtilityIndexed)this.storage;
    }

    public static interface SerializationWrapper
    extends Externalizable {
        public void setData(Externalizable var1);

        public Externalizable getData();

        public Class baseType();
    }
}

