/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class MultiInputStream
extends InputStream {
    Vector streams = new Vector();
    int currentStream = -1;

    public void addStream(InputStream inputStream) {
        this.streams.addElement(inputStream);
    }

    public boolean prepare() {
        if (this.streams.size() == 0) {
            return false;
        }
        this.currentStream = 0;
        return true;
    }

    public int read() throws IOException {
        if (this.currentStream == -1) {
            throw new IOException("Cannot read from unprepared MultiInputStream!");
        }
        InputStream inputStream = (InputStream)this.streams.elementAt(this.currentStream);
        int n = inputStream.read();
        if (n != -1) {
            return n;
        }
        while (n == -1 && this.currentStream + 1 < this.streams.size()) {
            ++this.currentStream;
            inputStream = (InputStream)this.streams.elementAt(this.currentStream);
            n = inputStream.read();
        }
        return n;
    }

    public int available() throws IOException {
        if (this.currentStream == -1) {
            throw new IOException("Cannot read from unprepared MultiInputStream!");
        }
        return ((InputStream)this.streams.elementAt(this.currentStream)).available();
    }

    public void close() throws IOException {
        if (this.currentStream == -1) {
            throw new IOException("Cannot read from unprepared MultiInputStream!");
        }
        Enumeration enumeration = this.streams.elements();
        while (enumeration.hasMoreElements()) {
            ((InputStream)enumeration.nextElement()).close();
        }
    }
}

