/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OrderedHashtable
extends Hashtable {
    private Vector orderedKeys;

    public OrderedHashtable() {
        this.orderedKeys = new Vector();
    }

    public OrderedHashtable(int n) {
        super(n);
        this.orderedKeys = new Vector(n);
    }

    public void clear() {
        this.orderedKeys.removeAllElements();
        super.clear();
    }

    public Object elementAt(int n) {
        return this.get(this.keyAt(n));
    }

    public Enumeration elements() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.size(); ++i) {
            vector.addElement(this.elementAt(i));
        }
        return vector.elements();
    }

    public int indexOfKey(Object object) {
        return this.orderedKeys.indexOf(object);
    }

    public Object keyAt(int n) {
        return this.orderedKeys.elementAt(n);
    }

    public Enumeration keys() {
        return this.orderedKeys.elements();
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.orderedKeys.indexOf(object);
        if (n == -1) {
            this.orderedKeys.addElement(object);
        } else {
            this.orderedKeys.setElementAt(object, n);
        }
        return super.put(object, object2);
    }

    public Object remove(Object object) {
        this.orderedKeys.removeElement(object);
        return super.remove(object);
    }

    public void removeAt(int n) {
        this.remove(this.keyAt(n));
        this.orderedKeys.removeElementAt(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            stringBuffer.append(e.toString());
            stringBuffer.append(" => ");
            stringBuffer.append(this.get(e).toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

