/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapMap
extends ExternalizableWrapper {
    public ExternalizableWrapper keyType;
    public ExternalizableWrapper dataType;
    public boolean ordered;

    public ExtWrapMap(Hashtable hashtable) {
        this(hashtable, null, null);
    }

    public ExtWrapMap(Hashtable hashtable, ExternalizableWrapper externalizableWrapper) {
        this(hashtable, null, externalizableWrapper);
    }

    public ExtWrapMap(Hashtable hashtable, ExternalizableWrapper externalizableWrapper, ExternalizableWrapper externalizableWrapper2) {
        if (hashtable == null) {
            throw new NullPointerException();
        }
        this.val = hashtable;
        this.keyType = externalizableWrapper;
        this.dataType = externalizableWrapper2;
        this.ordered = hashtable instanceof OrderedHashtable;
    }

    public ExtWrapMap() {
    }

    public ExtWrapMap(Class clazz, Class clazz2) {
        this(clazz, clazz2, false);
    }

    public ExtWrapMap(Class clazz, ExternalizableWrapper externalizableWrapper) {
        this(clazz, externalizableWrapper, false);
    }

    public ExtWrapMap(ExternalizableWrapper externalizableWrapper, ExternalizableWrapper externalizableWrapper2) {
        this(externalizableWrapper, externalizableWrapper2, false);
    }

    public ExtWrapMap(Class clazz, Class clazz2, boolean bl) {
        this(new ExtWrapBase(clazz), (ExternalizableWrapper)new ExtWrapBase(clazz2), bl);
    }

    public ExtWrapMap(Class clazz, ExternalizableWrapper externalizableWrapper, boolean bl) {
        this(new ExtWrapBase(clazz), externalizableWrapper, bl);
    }

    public ExtWrapMap(ExternalizableWrapper externalizableWrapper, ExternalizableWrapper externalizableWrapper2, boolean bl) {
        if (externalizableWrapper == null || externalizableWrapper2 == null) {
            throw new NullPointerException();
        }
        this.keyType = externalizableWrapper;
        this.dataType = externalizableWrapper2;
        this.ordered = bl;
    }

    public ExternalizableWrapper clone(Object object) {
        return new ExtWrapMap((Hashtable)object, this.keyType, this.dataType);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        Hashtable hashtable = this.ordered ? new OrderedHashtable() : new Hashtable();
        long l = ExtUtil.readNumeric(dataInputStream);
        int n = 0;
        while ((long)n < l) {
            Object object = ExtUtil.read(dataInputStream, this.keyType, prototypeFactory);
            Object object2 = ExtUtil.read(dataInputStream, this.dataType, prototypeFactory);
            hashtable.put(object, object2);
            ++n;
        }
        this.val = hashtable;
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        Hashtable hashtable = (Hashtable)this.val;
        ExtUtil.writeNumeric(dataOutputStream, hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            ExtUtil.write(dataOutputStream, this.keyType == null ? k : this.keyType.clone(k));
            ExtUtil.write(dataOutputStream, this.dataType == null ? v : this.dataType.clone(v));
        }
    }

    public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.ordered = ExtUtil.readBool(dataInputStream);
        this.keyType = ExtWrapTagged.readTag(dataInputStream, prototypeFactory);
        this.dataType = ExtWrapTagged.readTag(dataInputStream, prototypeFactory);
    }

    public void metaWriteExternal(DataOutputStream dataOutputStream) throws IOException {
        ExternalizableWrapper externalizableWrapper;
        Hashtable hashtable = (Hashtable)this.val;
        Object object = this.keyType == null ? (hashtable.size() == 0 ? new Object() : hashtable.keys().nextElement()) : (externalizableWrapper = this.keyType);
        ExternalizableWrapper externalizableWrapper2 = this.dataType == null ? (hashtable.size() == 0 ? new Object() : hashtable.elements().nextElement()) : this.dataType;
        ExtUtil.writeBool(dataOutputStream, this.ordered);
        ExtWrapTagged.writeTag(dataOutputStream, externalizableWrapper);
        ExtWrapTagged.writeTag(dataOutputStream, externalizableWrapper2);
    }
}

