/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javarosa.core.util.OrderedHashtable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapBase;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapMapPoly
extends ExternalizableWrapper {
    public ExternalizableWrapper keyType;
    public boolean ordered;

    public ExtWrapMapPoly(Hashtable hashtable) {
        this(hashtable, null);
    }

    public ExtWrapMapPoly(Hashtable hashtable, ExternalizableWrapper externalizableWrapper) {
        if (hashtable == null) {
            throw new NullPointerException();
        }
        this.val = hashtable;
        this.keyType = externalizableWrapper;
        this.ordered = hashtable instanceof OrderedHashtable;
    }

    public ExtWrapMapPoly() {
    }

    public ExtWrapMapPoly(Class clazz) {
        this(clazz, false);
    }

    public ExtWrapMapPoly(ExternalizableWrapper externalizableWrapper) {
        this(externalizableWrapper, false);
    }

    public ExtWrapMapPoly(Class clazz, boolean bl) {
        this(new ExtWrapBase(clazz), bl);
    }

    public ExtWrapMapPoly(ExternalizableWrapper externalizableWrapper, boolean bl) {
        if (externalizableWrapper == null) {
            throw new NullPointerException();
        }
        this.keyType = externalizableWrapper;
        this.ordered = bl;
    }

    public ExternalizableWrapper clone(Object object) {
        return new ExtWrapMapPoly((Hashtable)object, this.keyType);
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        Hashtable hashtable = this.ordered ? new OrderedHashtable() : new Hashtable();
        long l = ExtUtil.readNumeric(dataInputStream);
        int n = 0;
        while ((long)n < l) {
            Object object = ExtUtil.read(dataInputStream, this.keyType, prototypeFactory);
            Object object2 = ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
            hashtable.put(object, object2);
            ++n;
        }
        this.val = hashtable;
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        Hashtable hashtable = (Hashtable)this.val;
        ExtUtil.writeNumeric(dataOutputStream, hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            ExtUtil.write(dataOutputStream, this.keyType == null ? k : this.keyType.clone(k));
            ExtUtil.write(dataOutputStream, new ExtWrapTagged(v));
        }
    }

    public void metaReadExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.ordered = ExtUtil.readBool(dataInputStream);
        this.keyType = ExtWrapTagged.readTag(dataInputStream, prototypeFactory);
    }

    public void metaWriteExternal(DataOutputStream dataOutputStream) throws IOException {
        Hashtable hashtable = (Hashtable)this.val;
        ExtUtil.writeBool(dataOutputStream, this.ordered);
        ExternalizableWrapper externalizableWrapper = this.keyType == null ? (hashtable.size() == 0 ? new Object() : hashtable.keys().nextElement()) : this.keyType;
        ExtWrapTagged.writeTag(dataOutputStream, externalizableWrapper);
    }
}

