/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IAnswerDataSerializer;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.utils.IInstanceSerializingVisitor;
import org.javarosa.core.services.transport.payload.ByteArrayPayload;
import org.javarosa.core.services.transport.payload.DataPointerPayload;
import org.javarosa.core.services.transport.payload.IDataPayload;
import org.javarosa.core.services.transport.payload.MultiMessagePayload;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.util.XFormAnswerDataSerializer;
import org.javarosa.xform.util.XFormSerializer;
import org.kxml2.kdom.Document;
import org.kxml2.kdom.Element;

public class XFormSerializingVisitor
implements IInstanceSerializingVisitor {
    Document theXmlDoc;
    IAnswerDataSerializer serializer;
    TreeReference rootRef;
    FormDef schema;
    Vector dataPointers;

    private void init() {
        this.theXmlDoc = null;
        this.schema = null;
        this.dataPointers = new Vector();
    }

    public byte[] serializeInstance(FormInstance formInstance, FormDef formDef) throws IOException {
        this.init();
        this.schema = formDef;
        return this.serializeInstance(formInstance);
    }

    public byte[] serializeInstance(FormInstance formInstance) throws IOException {
        return this.serializeInstance(formInstance, new XPathReference("/"));
    }

    public byte[] serializeInstance(FormInstance formInstance, IDataReference iDataReference) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(iDataReference);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        formInstance.accept(this);
        if (this.theXmlDoc != null) {
            return XFormSerializer.getString(this.theXmlDoc).getBytes("UTF-8");
        }
        return null;
    }

    public IDataPayload createSerializedPayload(FormInstance formInstance) throws IOException {
        return this.createSerializedPayload(formInstance, new XPathReference("/"));
    }

    public IDataPayload createSerializedPayload(FormInstance formInstance, IDataReference iDataReference) throws IOException {
        this.init();
        this.rootRef = FormInstance.unpackReference(iDataReference);
        if (this.serializer == null) {
            this.setAnswerDataSerializer(new XFormAnswerDataSerializer());
        }
        formInstance.accept(this);
        if (this.theXmlDoc != null) {
            byte[] byArray = XFormSerializer.getString(this.theXmlDoc).getBytes("UTF-8");
            if (this.dataPointers.size() == 0) {
                return new ByteArrayPayload(byArray, null, 1);
            }
            MultiMessagePayload multiMessagePayload = new MultiMessagePayload();
            multiMessagePayload.addPayload(new ByteArrayPayload(byArray, null, 1));
            Enumeration enumeration = this.dataPointers.elements();
            while (enumeration.hasMoreElements()) {
                IDataPointer iDataPointer = (IDataPointer)enumeration.nextElement();
                multiMessagePayload.addPayload(new DataPointerPayload(iDataPointer));
            }
            return multiMessagePayload;
        }
        return null;
    }

    public void visit(FormInstance formInstance) {
        String[] stringArray;
        this.theXmlDoc = new Document();
        TreeElement treeElement = formInstance.resolveReference(this.rootRef);
        if (treeElement == null) {
            treeElement = formInstance.getRoot();
        }
        for (int i = 0; i < treeElement.getNumChildren(); ++i) {
            stringArray = treeElement.getChildAt(i);
        }
        if (treeElement != null) {
            this.theXmlDoc.addChild(2, this.serializeNode(treeElement));
        }
        Element element = this.theXmlDoc.getElement(0);
        stringArray = formInstance.getNamespacePrefixes();
        for (int i = 0; i < stringArray.length; ++i) {
            element.setPrefix(stringArray[i], formInstance.getNamespaceURI(stringArray[i]));
        }
        if (formInstance.schema != null) {
            element.setNamespace(formInstance.schema);
            element.setPrefix("", formInstance.schema);
        }
    }

    public Element serializeNode(TreeElement treeElement) {
        Object object;
        Object object2;
        Element element = new Element();
        if (!treeElement.isRelevant() || treeElement.getMult() == -2) {
            return null;
        }
        if (treeElement.getValue() != null) {
            object2 = this.serializer.serializeAnswerData(treeElement.getValue(), treeElement.dataType);
            if (object2 instanceof Element) {
                element = (Element)object2;
            } else if (object2 instanceof String) {
                element = new Element();
                element.addChild(4, (String)object2);
            } else {
                throw new RuntimeException("Can't handle serialized output for" + treeElement.getValue().toString() + ", " + object2);
            }
            if (this.serializer.containsExternalData(treeElement.getValue()).booleanValue()) {
                object = this.serializer.retrieveExternalDataPointer(treeElement.getValue());
                for (int i = 0; i < ((IDataPointer[])object).length; ++i) {
                    this.dataPointers.addElement(object[i]);
                }
            }
        } else {
            String string;
            int n;
            object2 = new Vector();
            for (n = 0; n < treeElement.getNumChildren(); ++n) {
                string = treeElement.getChildAt(n).getName();
                System.out.println("CHILDNAME: " + string);
                if (((Vector)object2).contains(string)) continue;
                ((Vector)object2).addElement(string);
            }
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                string = (String)((Vector)object2).elementAt(n);
                int n2 = treeElement.getChildMultiplicity(string);
                for (int i = 0; i < n2; ++i) {
                    Element element2 = this.serializeNode(treeElement.getChild(string, i));
                    if (element2 == null) continue;
                    element.addChild(2, element2);
                }
            }
        }
        element.setName(treeElement.getName());
        for (int i = 0; i < treeElement.getAttributeCount(); ++i) {
            object = treeElement.getAttributeNamespace(i);
            String string = treeElement.getAttributeName(i);
            String string2 = treeElement.getAttributeValue(i);
            element.setAttribute((String)object, string, string2);
        }
        return element;
    }

    public void setAnswerDataSerializer(IAnswerDataSerializer iAnswerDataSerializer) {
        this.serializer = iAnswerDataSerializer;
    }

    public IInstanceSerializingVisitor newInstance() {
        XFormSerializingVisitor xFormSerializingVisitor = new XFormSerializingVisitor();
        xFormSerializingVisitor.setAnswerDataSerializer(this.serializer);
        return xFormSerializingVisitor;
    }
}

