/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.util.Date;
import java.util.Vector;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.data.BooleanData;
import org.javarosa.core.model.data.DateData;
import org.javarosa.core.model.data.DateTimeData;
import org.javarosa.core.model.data.DecimalData;
import org.javarosa.core.model.data.GeoPointData;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.IntegerData;
import org.javarosa.core.model.data.SelectMultiData;
import org.javarosa.core.model.data.SelectOneData;
import org.javarosa.core.model.data.StringData;
import org.javarosa.core.model.data.TimeData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.data.helper.Selection;
import org.javarosa.core.model.utils.DateUtils;

public class XFormAnswerDataParser {
    public static IAnswerData getAnswerData(String string, int n) {
        return XFormAnswerDataParser.getAnswerData(string, n, null);
    }

    public static IAnswerData getAnswerData(String string, int n, QuestionDef questionDef) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            string2 = null;
        }
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 11: 
            case 12: {
                return new StringData(string);
            }
            case 2: {
                try {
                    return string2 == null ? null : new IntegerData(Integer.parseInt(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 3: {
                try {
                    return string2 == null ? null : new DecimalData(Double.parseDouble(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            case 7: {
                Vector vector = XFormAnswerDataParser.getSelections(string, questionDef);
                return vector.size() == 0 ? null : new SelectOneData((Selection)vector.elementAt(0));
            }
            case 8: {
                return new SelectMultiData(XFormAnswerDataParser.getSelections(string, questionDef));
            }
            case 6: {
                Date date = string2 == null ? null : DateUtils.parseDateTime(string2);
                return date == null ? null : new DateTimeData(date);
            }
            case 4: {
                Date date = string2 == null ? null : DateUtils.parseDate(string2);
                return date == null ? null : new DateData(date);
            }
            case 5: {
                Date date = string2 == null ? null : DateUtils.parseTime(string2);
                return date == null ? null : new TimeData(date);
            }
            case 9: {
                if (string2 == null) {
                    return null;
                }
                if (string2.equals("1")) {
                    return new BooleanData(true);
                }
                if (string2.equals("0")) {
                    return new BooleanData(false);
                }
                return string2.equals("t") ? new BooleanData(true) : new BooleanData(false);
            }
            case 10: {
                try {
                    Vector vector = string2 == null ? null : DateUtils.split(string2, " ", false);
                    int n2 = vector.size();
                    double[] dArray = new double[n2];
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = Double.parseDouble((String)vector.elementAt(i));
                    }
                    return new GeoPointData(dArray);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        }
        return new UncastData(string2);
    }

    private static Vector getSelections(String string, QuestionDef questionDef) {
        Vector<Selection> vector = new Vector<Selection>();
        Vector vector2 = DateUtils.split(string, " ", true);
        for (int i = 0; i < vector2.size(); ++i) {
            Selection selection = XFormAnswerDataParser.getSelection((String)vector2.elementAt(i), questionDef);
            if (selection == null) continue;
            vector.addElement(selection);
        }
        return vector;
    }

    private static Selection getSelection(String string, QuestionDef questionDef) {
        SelectChoice selectChoice;
        Selection selection = questionDef == null || questionDef.getDynamicChoices() != null ? new Selection(string) : ((selectChoice = questionDef.getChoiceForValue(string)) != null ? selectChoice.selection() : null);
        return selection;
    }
}

