/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.xform.parse.XFormParser;
import org.kxml2.kdom.Element;

public class XFormUtils {
    public static FormDef getFormFromResource(String string) {
        InputStream inputStream = System.class.getResourceAsStream(string);
        if (inputStream == null) {
            System.err.println("Can't find form resource \"" + string + "\". Is it in the JAR?");
            return null;
        }
        return XFormUtils.getFormFromInputStream(inputStream);
    }

    public static FormDef getFormFromInputStream(InputStream inputStream) {
        InputStreamReader inputStreamReader;
        FormDef formDef = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("UTF 8 encoding unavailable, trying default encoding");
            inputStreamReader = new InputStreamReader(inputStream);
        }
        if (inputStreamReader != null) {
            formDef = XFormParser.getFormDef(inputStreamReader);
        }
        try {
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            System.err.println("IO Exception while closing stream.");
            iOException.printStackTrace();
        }
        return formDef;
    }

    public static FormDef getFormFromSerializedResource(String string) {
        FormDef formDef = null;
        InputStream inputStream = System.class.getResourceAsStream(string);
        try {
            if (inputStream != null) {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                formDef = (FormDef)ExtUtil.read(dataInputStream, FormDef.class);
                dataInputStream.close();
                inputStream.close();
            } else {
                System.out.println("ResourceStream NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (DeserializationException deserializationException) {
            deserializationException.printStackTrace();
        }
        return formDef;
    }

    public static Vector getAttributeList(Element element) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < element.getAttributeCount(); ++i) {
            vector.addElement(element.getAttributeName(i));
        }
        return vector;
    }

    public static Vector getUnusedAttributes(Element element, Vector vector) {
        Vector vector2 = XFormUtils.getAttributeList(element);
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector2.contains(vector.elementAt(i))) continue;
            vector2.removeElement(vector.elementAt(i));
        }
        return vector2;
    }

    public static String unusedAttWarning(Element element, Vector vector) {
        String string = "Warning: ";
        Vector vector2 = XFormUtils.getUnusedAttributes(element, vector);
        string = string + vector2.size() + " Unrecognized attributes found in Element [" + element.getName() + "] and will be ignored: ";
        string = string + "[";
        for (int i = 0; i < vector2.size(); ++i) {
            string = string + vector2.elementAt(i);
            if (i == vector2.size() - 1) continue;
            string = string + ",";
        }
        string = string + "] ";
        string = string + "Location:\n" + XFormParser.getVagueLocation(element);
        return string;
    }

    public static boolean showUnusedAttributeWarning(Element element, Vector vector) {
        return XFormUtils.getUnusedAttributes(element, vector).size() > 0;
    }

    public static boolean isOutput(Element element) {
        return element.getName().toLowerCase().equals("output");
    }
}

