/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.XPathUnsupportedException;
import org.javarosa.xpath.expr.XPathExpression;

public class XPathFilterExpr
extends XPathExpression {
    public XPathExpression x;
    public XPathExpression[] predicates;

    public XPathFilterExpr() {
    }

    public XPathFilterExpr(XPathExpression xPathExpression, XPathExpression[] xPathExpressionArray) {
        this.x = xPathExpression;
        this.predicates = xPathExpressionArray;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        throw new XPathUnsupportedException("filter expression");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{filt-expr:");
        stringBuffer.append(this.x.toString());
        stringBuffer.append(",{");
        for (int i = 0; i < this.predicates.length; ++i) {
            stringBuffer.append(this.predicates[i].toString());
            if (i >= this.predicates.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("}}");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof XPathFilterExpr) {
            XPathFilterExpr xPathFilterExpr = (XPathFilterExpr)object;
            Vector<XPathExpression> vector = new Vector<XPathExpression>();
            for (int i = 0; i < this.predicates.length; ++i) {
                vector.addElement(this.predicates[i]);
            }
            Vector<XPathExpression> vector2 = new Vector<XPathExpression>();
            for (int i = 0; i < xPathFilterExpr.predicates.length; ++i) {
                vector2.addElement(xPathFilterExpr.predicates[i]);
            }
            return this.x.equals(xPathFilterExpr.x) && ExtUtil.vectorEquals(vector, vector2);
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.x = (XPathExpression)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
        Vector vector = (Vector)ExtUtil.read(dataInputStream, new ExtWrapListPoly(), prototypeFactory);
        this.predicates = new XPathExpression[vector.size()];
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i] = (XPathExpression)vector.elementAt(i);
        }
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        Vector<XPathExpression> vector = new Vector<XPathExpression>();
        for (int i = 0; i < this.predicates.length; ++i) {
            vector.addElement(this.predicates[i]);
        }
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.x));
        ExtUtil.write(dataOutputStream, new ExtWrapListPoly(vector));
    }
}

