/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;

public class XPathNumericLiteral
extends XPathExpression {
    public double d;

    public XPathNumericLiteral() {
    }

    public XPathNumericLiteral(Double d) {
        this.d = d;
    }

    public Object eval(FormInstance formInstance, EvaluationContext evaluationContext) {
        return new Double(this.d);
    }

    public String toString() {
        return "{num:" + Double.toString(this.d) + "}";
    }

    public boolean equals(Object object) {
        if (object instanceof XPathNumericLiteral) {
            XPathNumericLiteral xPathNumericLiteral = (XPathNumericLiteral)object;
            return Double.isNaN(this.d) ? Double.isNaN(xPathNumericLiteral.d) : this.d == xPathNumericLiteral.d;
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.d = dataInputStream.readByte() == 0 ? (double)ExtUtil.readNumeric(dataInputStream) : ExtUtil.readDecimal(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        if (this.d == (double)((int)this.d)) {
            dataOutputStream.writeByte(0);
            ExtUtil.writeNumeric(dataOutputStream, (int)this.d);
        } else {
            dataOutputStream.writeByte(1);
            ExtUtil.writeDecimal(dataOutputStream, this.d);
        }
    }
}

