/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class XPathQName
implements Externalizable {
    public String namespace;
    public String name;

    public XPathQName() {
    }

    public XPathQName(String string) {
        int n;
        int n2 = n = string == null ? -1 : string.indexOf(":");
        if (n == -1) {
            this.init(null, string);
        } else {
            this.init(string.substring(0, n), string.substring(n + 1));
        }
    }

    public XPathQName(String string, String string2) {
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        if (string2 == null || string2 != null && string2.length() == 0 || string != null && string.length() == 0) {
            throw new IllegalArgumentException("Invalid QName");
        }
        this.namespace = string;
        this.name = string2;
    }

    public String toString() {
        return this.namespace == null ? this.name : this.namespace + ":" + this.name;
    }

    public boolean equals(Object object) {
        if (object instanceof XPathQName) {
            XPathQName xPathQName = (XPathQName)object;
            return ExtUtil.equals(this.namespace, xPathQName.namespace) && this.name.equals(xPathQName.name);
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.namespace = (String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class));
        this.name = ExtUtil.readString(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.namespace));
        ExtUtil.writeString(dataOutputStream, this.name);
    }
}

