/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathQName;

public class XPathStep
implements Externalizable {
    public static final int AXIS_CHILD = 0;
    public static final int AXIS_DESCENDANT = 1;
    public static final int AXIS_PARENT = 2;
    public static final int AXIS_ANCESTOR = 3;
    public static final int AXIS_FOLLOWING_SIBLING = 4;
    public static final int AXIS_PRECEDING_SIBLING = 5;
    public static final int AXIS_FOLLOWING = 6;
    public static final int AXIS_PRECEDING = 7;
    public static final int AXIS_ATTRIBUTE = 8;
    public static final int AXIS_NAMESPACE = 9;
    public static final int AXIS_SELF = 10;
    public static final int AXIS_DESCENDANT_OR_SELF = 11;
    public static final int AXIS_ANCESTOR_OR_SELF = 12;
    public static final int TEST_NAME = 0;
    public static final int TEST_NAME_WILDCARD = 1;
    public static final int TEST_NAMESPACE_WILDCARD = 2;
    public static final int TEST_TYPE_NODE = 3;
    public static final int TEST_TYPE_TEXT = 4;
    public static final int TEST_TYPE_COMMENT = 5;
    public static final int TEST_TYPE_PROCESSING_INSTRUCTION = 6;
    public int axis;
    public int test;
    public XPathExpression[] predicates;
    public XPathQName name;
    public String namespace;
    public String literal;

    public static XPathStep ABBR_SELF() {
        return new XPathStep(10, 3);
    }

    public static XPathStep ABBR_PARENT() {
        return new XPathStep(2, 3);
    }

    public static XPathStep ABBR_DESCENDANTS() {
        return new XPathStep(11, 3);
    }

    public XPathStep() {
    }

    public XPathStep(int n, int n2) {
        this.axis = n;
        this.test = n2;
        this.predicates = new XPathExpression[0];
    }

    public XPathStep(int n, XPathQName xPathQName) {
        this(n, 0);
        this.name = xPathQName;
    }

    public XPathStep(int n, String string) {
        this(n, 2);
        this.namespace = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{step:");
        stringBuffer.append(XPathStep.axisStr(this.axis));
        stringBuffer.append(",");
        stringBuffer.append(this.testStr());
        if (this.predicates.length > 0) {
            stringBuffer.append(",{");
            for (int i = 0; i < this.predicates.length; ++i) {
                stringBuffer.append(this.predicates[i].toString());
                if (i >= this.predicates.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String axisStr(int n) {
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "descendant";
            }
            case 2: {
                return "parent";
            }
            case 3: {
                return "ancestor";
            }
            case 4: {
                return "following-sibling";
            }
            case 5: {
                return "preceding-sibling";
            }
            case 6: {
                return "following";
            }
            case 7: {
                return "preceding";
            }
            case 8: {
                return "attribute";
            }
            case 9: {
                return "namespace";
            }
            case 10: {
                return "self";
            }
            case 11: {
                return "descendant-or-self";
            }
            case 12: {
                return "ancestor-or-self";
            }
        }
        return null;
    }

    public String testStr() {
        switch (this.test) {
            case 0: {
                return this.name.toString();
            }
            case 1: {
                return "*";
            }
            case 2: {
                return this.namespace + ":*";
            }
            case 3: {
                return "node()";
            }
            case 4: {
                return "text()";
            }
            case 5: {
                return "comment()";
            }
            case 6: {
                return "proc-instr(" + (this.literal == null ? "" : "'" + this.literal + "'") + ")";
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof XPathStep) {
            XPathStep xPathStep = (XPathStep)object;
            if (this.axis != xPathStep.axis && this.test != xPathStep.test || this.predicates.length != xPathStep.predicates.length) {
                return false;
            }
            switch (this.test) {
                case 0: {
                    if (this.name.equals(xPathStep.name)) break;
                    return false;
                }
                case 2: {
                    if (this.namespace.equals(xPathStep.namespace)) break;
                    return false;
                }
                case 6: {
                    if (ExtUtil.equals(this.literal, xPathStep.literal)) break;
                    return false;
                }
            }
            return ExtUtil.arrayEquals(this.predicates, xPathStep.predicates);
        }
        return false;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.axis = ExtUtil.readInt(dataInputStream);
        this.test = ExtUtil.readInt(dataInputStream);
        switch (this.test) {
            case 0: {
                this.name = (XPathQName)ExtUtil.read(dataInputStream, XPathQName.class);
                break;
            }
            case 2: {
                this.namespace = ExtUtil.readString(dataInputStream);
                break;
            }
            case 6: {
                this.literal = (String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class));
            }
        }
        Vector vector = (Vector)ExtUtil.read(dataInputStream, new ExtWrapListPoly(), prototypeFactory);
        this.predicates = new XPathExpression[vector.size()];
        for (int i = 0; i < this.predicates.length; ++i) {
            this.predicates[i] = (XPathExpression)vector.elementAt(i);
        }
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.axis);
        ExtUtil.writeNumeric(dataOutputStream, this.test);
        switch (this.test) {
            case 0: {
                ExtUtil.write(dataOutputStream, this.name);
                break;
            }
            case 2: {
                ExtUtil.writeString(dataOutputStream, this.namespace);
                break;
            }
            case 6: {
                ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.literal));
            }
        }
        Vector<XPathExpression> vector = new Vector<XPathExpression>();
        for (int i = 0; i < this.predicates.length; ++i) {
            vector.addElement(this.predicates[i]);
        }
        ExtUtil.write(dataOutputStream, new ExtWrapListPoly(vector));
    }
}

