/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.parser.ast;

import java.util.Vector;
import org.javarosa.xpath.expr.XPathExpression;
import org.javarosa.xpath.expr.XPathFilterExpr;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.javarosa.xpath.expr.XPathStep;
import org.javarosa.xpath.parser.Parser;
import org.javarosa.xpath.parser.XPathSyntaxException;
import org.javarosa.xpath.parser.ast.ASTNode;
import org.javarosa.xpath.parser.ast.ASTNodePathStep;

public class ASTNodeLocPath
extends ASTNode {
    public Vector clauses = new Vector();
    public Vector separators = new Vector();

    public Vector getChildren() {
        return this.clauses;
    }

    public boolean isAbsolute() {
        return this.clauses.size() == this.separators.size() || this.clauses.size() == 0 && this.separators.size() == 1;
    }

    public XPathExpression build() throws XPathSyntaxException {
        Vector<XPathStep> vector = new Vector<XPathStep>();
        XPathExpression xPathExpression = null;
        int n = this.isAbsolute() ? 1 : 0;
        for (int i = 0; i < this.clauses.size() + n; ++i) {
            if (n == 0 || i > 0) {
                if (this.clauses.elementAt(i - n) instanceof ASTNodePathStep) {
                    vector.addElement(((ASTNodePathStep)this.clauses.elementAt(i - n)).getStep());
                } else {
                    xPathExpression = ((ASTNode)this.clauses.elementAt(i - n)).build();
                }
            }
            if (i >= this.separators.size() || Parser.vectInt(this.separators, i) != 6) continue;
            vector.addElement(XPathStep.ABBR_DESCENDANTS());
        }
        XPathStep[] xPathStepArray = new XPathStep[vector.size()];
        for (int i = 0; i < xPathStepArray.length; ++i) {
            xPathStepArray[i] = (XPathStep)vector.elementAt(i);
        }
        if (xPathExpression == null) {
            return new XPathPathExpr(this.isAbsolute() ? 0 : 1, xPathStepArray);
        }
        if (xPathExpression instanceof XPathFilterExpr) {
            return new XPathPathExpr((XPathFilterExpr)xPathExpression, xPathStepArray);
        }
        return new XPathPathExpr(new XPathFilterExpr(xPathExpression, new XPathExpression[0]), xPathStepArray);
    }
}

