/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import org.javarosa.core.model.instance.TreeReference;

public class FormIndex {
    private boolean beginningOfForm = false;
    private boolean endOfForm = false;
    private int localIndex;
    private int instanceIndex = -1;
    private FormIndex nextLevel;
    private TreeReference reference;

    public static FormIndex createBeginningOfFormIndex() {
        FormIndex formIndex = new FormIndex(-1, null);
        formIndex.beginningOfForm = true;
        return formIndex;
    }

    public static FormIndex createEndOfFormIndex() {
        FormIndex formIndex = new FormIndex(-1, null);
        formIndex.endOfForm = true;
        return formIndex;
    }

    public FormIndex(int n, TreeReference treeReference) {
        this.localIndex = n;
        this.reference = treeReference;
    }

    public FormIndex(int n, int n2, TreeReference treeReference) {
        this.localIndex = n;
        this.instanceIndex = n2;
        this.reference = treeReference;
    }

    public FormIndex(FormIndex formIndex, int n, TreeReference treeReference) {
        this(n, treeReference);
        this.nextLevel = formIndex;
    }

    public FormIndex(FormIndex formIndex, FormIndex formIndex2) {
        if (formIndex2 == null) {
            this.nextLevel = formIndex.nextLevel;
            this.localIndex = formIndex.localIndex;
            this.instanceIndex = formIndex.instanceIndex;
            this.reference = formIndex.reference;
        } else {
            this.nextLevel = formIndex;
            this.localIndex = formIndex2.getLocalIndex();
            this.instanceIndex = formIndex2.getInstanceIndex();
            this.reference = formIndex2.reference;
        }
    }

    public FormIndex(FormIndex formIndex, int n, int n2, TreeReference treeReference) {
        this(formIndex, n, treeReference);
        this.instanceIndex = n2;
    }

    public boolean isInForm() {
        return !this.beginningOfForm && !this.endOfForm;
    }

    public int getLocalIndex() {
        return this.localIndex;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public int getElementMultiplicity() {
        return this.getTerminal().instanceIndex;
    }

    public FormIndex getNextLevel() {
        return this.nextLevel;
    }

    public TreeReference getLocalReference() {
        return this.reference;
    }

    public TreeReference getReference() {
        return this.getTerminal().reference;
    }

    public FormIndex getTerminal() {
        FormIndex formIndex = this;
        while (formIndex.nextLevel != null) {
            formIndex = formIndex.nextLevel;
        }
        return formIndex;
    }

    public boolean isTerminal() {
        return this.nextLevel == null;
    }

    public boolean isEndOfFormIndex() {
        return this.endOfForm;
    }

    public boolean isBeginningOfFormIndex() {
        return this.beginningOfForm;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormIndex)) {
            return false;
        }
        FormIndex formIndex = this;
        FormIndex formIndex2 = (FormIndex)object;
        return formIndex.compareTo(formIndex2) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FormIndex)) {
            throw new IllegalArgumentException("Attempt to compare Object of type " + object.getClass().getName() + " to a FormIndex");
        }
        FormIndex formIndex = this;
        FormIndex formIndex2 = (FormIndex)object;
        if (formIndex.beginningOfForm) {
            return formIndex2.beginningOfForm ? 0 : -1;
        }
        if (formIndex.endOfForm) {
            return formIndex2.endOfForm ? 0 : 1;
        }
        if (formIndex2.beginningOfForm) {
            return 1;
        }
        if (formIndex2.endOfForm) {
            return -1;
        }
        if (formIndex.localIndex != formIndex2.localIndex) {
            return formIndex.localIndex < formIndex2.localIndex ? -1 : 1;
        }
        if (formIndex.instanceIndex != formIndex2.instanceIndex) {
            return formIndex.instanceIndex < formIndex2.instanceIndex ? -1 : 1;
        }
        if (formIndex.getNextLevel() == null != (formIndex2.getNextLevel() == null)) {
            return formIndex.getNextLevel() == null ? -1 : 1;
        }
        if (formIndex.getNextLevel() != null) {
            return formIndex.getNextLevel().compareTo(formIndex2.getNextLevel());
        }
        return 0;
    }

    public FormIndex snip() {
        FormIndex formIndex = new FormIndex(this.localIndex, this.instanceIndex, this.reference);
        return formIndex;
    }

    public FormIndex diff(FormIndex formIndex) {
        if (formIndex == null) {
            return this;
        }
        if (!FormIndex.isSubIndex(this, formIndex)) {
            return null;
        }
        if (formIndex.equals(this)) {
            return null;
        }
        return new FormIndex(this.nextLevel.diff(formIndex), this.snip());
    }

    public String toString() {
        String string = "";
        FormIndex formIndex = this;
        while (formIndex != null) {
            string = string + formIndex.getLocalIndex();
            string = string + (formIndex.getInstanceIndex() == -1 ? ", " : "_" + formIndex.getInstanceIndex() + ", ");
            formIndex = formIndex.nextLevel;
        }
        return string;
    }

    public int getDepth() {
        int n = 0;
        FormIndex formIndex = this;
        while (formIndex != null) {
            formIndex = formIndex.nextLevel;
            ++n;
        }
        return n;
    }

    public static FormIndex trimNegativeIndices(FormIndex formIndex) {
        if (!formIndex.isTerminal()) {
            return new FormIndex(FormIndex.trimNegativeIndices(formIndex.nextLevel), formIndex);
        }
        if (formIndex.getLocalIndex() < 0) {
            return null;
        }
        return formIndex;
    }

    public static boolean isSubIndex(FormIndex formIndex, FormIndex formIndex2) {
        if (formIndex2.equals(formIndex)) {
            return true;
        }
        if (formIndex == null) {
            return false;
        }
        return FormIndex.isSubIndex(formIndex.nextLevel, formIndex2);
    }

    public static boolean isSubElement(FormIndex formIndex, FormIndex formIndex2) {
        while (!formIndex.isTerminal() && !formIndex2.isTerminal()) {
            if (formIndex.getLocalIndex() != formIndex2.getLocalIndex()) {
                return false;
            }
            if (formIndex.getInstanceIndex() != formIndex2.getInstanceIndex()) {
                return false;
            }
            formIndex = formIndex.nextLevel;
            formIndex2 = formIndex2.nextLevel;
        }
        if (!formIndex.isTerminal() && formIndex2.isTerminal()) {
            return false;
        }
        if (formIndex.getLocalIndex() != formIndex2.getLocalIndex()) {
            return false;
        }
        return formIndex.getInstanceIndex() == -1 || formIndex.getInstanceIndex() == formIndex2.getInstanceIndex();
    }
}

