/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemsetBinding
implements Externalizable,
Localizable {
    public TreeReference nodesetRef;
    public IConditionExpr nodesetExpr;
    public TreeReference contextRef;
    public TreeReference labelRef;
    public IConditionExpr labelExpr;
    public boolean labelIsItext;
    public boolean copyMode;
    public TreeReference copyRef;
    public TreeReference valueRef;
    public IConditionExpr valueExpr;
    private TreeReference destRef;
    private Vector<SelectChoice> choices;

    public Vector<SelectChoice> getChoices() {
        return this.choices;
    }

    public void setChoices(Vector<SelectChoice> vector, Localizer localizer) {
        String string;
        if (this.choices != null) {
            System.out.println("warning: previous choices not cleared out");
            this.clearChoices();
        }
        this.choices = vector;
        if (localizer != null && (string = localizer.getLocale()) != null) {
            this.localeChanged(string, localizer);
        }
    }

    public void clearChoices() {
        this.choices = null;
    }

    @Override
    public void localeChanged(String string, Localizer localizer) {
        if (this.choices != null) {
            for (int i = 0; i < this.choices.size(); ++i) {
                this.choices.elementAt(i).localeChanged(string, localizer);
            }
        }
    }

    public void setDestRef(QuestionDef questionDef) {
        this.destRef = FormInstance.unpackReference(questionDef.getBind()).clone();
        if (this.copyMode) {
            this.destRef.add(this.copyRef.getNameLast(), -1);
        }
    }

    public TreeReference getDestRef() {
        return this.destRef;
    }

    public IConditionExpr getRelativeValue() {
        TreeReference treeReference = null;
        if (this.copyRef == null) {
            treeReference = this.valueRef;
        } else if (this.valueRef != null) {
            treeReference = this.valueRef.relativize(this.copyRef);
        }
        return treeReference != null ? RestoreUtils.xfFact.refToPathExpr(treeReference) : null;
    }

    @Override
    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.nodesetRef = (TreeReference)ExtUtil.read(dataInputStream, TreeReference.class, prototypeFactory);
        this.nodesetExpr = (IConditionExpr)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
        this.contextRef = (TreeReference)ExtUtil.read(dataInputStream, TreeReference.class, prototypeFactory);
        this.labelRef = (TreeReference)ExtUtil.read(dataInputStream, TreeReference.class, prototypeFactory);
        this.labelExpr = (IConditionExpr)ExtUtil.read(dataInputStream, new ExtWrapTagged(), prototypeFactory);
        this.valueRef = (TreeReference)ExtUtil.read(dataInputStream, new ExtWrapNullable(TreeReference.class), prototypeFactory);
        this.valueExpr = (IConditionExpr)ExtUtil.read(dataInputStream, new ExtWrapNullable(new ExtWrapTagged()), prototypeFactory);
        this.copyRef = (TreeReference)ExtUtil.read(dataInputStream, new ExtWrapNullable(TreeReference.class), prototypeFactory);
        this.labelIsItext = ExtUtil.readBool(dataInputStream);
        this.copyMode = ExtUtil.readBool(dataInputStream);
    }

    @Override
    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.write(dataOutputStream, this.nodesetRef);
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.nodesetExpr));
        ExtUtil.write(dataOutputStream, this.contextRef);
        ExtUtil.write(dataOutputStream, this.labelRef);
        ExtUtil.write(dataOutputStream, new ExtWrapTagged(this.labelExpr));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.valueRef));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.valueExpr == null ? null : new ExtWrapTagged(this.valueExpr)));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.copyRef));
        ExtUtil.writeBool(dataOutputStream, this.labelIsItext);
        ExtUtil.writeBool(dataOutputStream, this.copyMode);
    }
}

