/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.javarosa.core.model.FormElementStateListener;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapList;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.PrototypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionDef
implements IFormElement,
Localizable {
    private int id;
    private IDataReference binding;
    private int controlType;
    private String appearanceAttr;
    private String helpTextID;
    private String labelInnerText;
    private String helpText;
    private String textID;
    private Vector<SelectChoice> choices;
    private ItemsetBinding dynamicChoices;
    Vector observers;

    public QuestionDef() {
        this(-1, 1);
    }

    public QuestionDef(int n, int n2) {
        this.setID(n);
        this.setControlType(n2);
        this.observers = new Vector();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int n) {
        this.id = n;
    }

    @Override
    public IDataReference getBind() {
        return this.binding;
    }

    public void setBind(IDataReference iDataReference) {
        this.binding = iDataReference;
    }

    public int getControlType() {
        return this.controlType;
    }

    public void setControlType(int n) {
        this.controlType = n;
    }

    @Override
    public String getAppearanceAttr() {
        return this.appearanceAttr;
    }

    @Override
    public void setAppearanceAttr(String string) {
        this.appearanceAttr = string;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String string) {
        this.helpText = string;
    }

    public String getHelpTextID() {
        return this.helpTextID;
    }

    public void setHelpTextID(String string) {
        this.helpTextID = string;
    }

    public void addSelectChoice(SelectChoice selectChoice) {
        if (this.choices == null) {
            this.choices = new Vector();
        }
        selectChoice.setIndex(this.choices.size());
        this.choices.addElement(selectChoice);
    }

    public void removeSelectChoice(SelectChoice selectChoice) {
        if (this.choices == null) {
            selectChoice.setIndex(0);
            return;
        }
        if (this.choices.contains(selectChoice)) {
            this.choices.removeElement(selectChoice);
        }
    }

    public void removeAllSelectChoices() {
        if (this.choices != null) {
            this.choices.removeAllElements();
        }
    }

    public Vector<SelectChoice> getChoices() {
        return this.choices;
    }

    public SelectChoice getChoice(int n) {
        return this.choices.elementAt(n);
    }

    public int getNumChoices() {
        return this.choices != null ? this.choices.size() : 0;
    }

    public SelectChoice getChoiceForValue(String string) {
        for (int i = 0; i < this.getNumChoices(); ++i) {
            if (!this.getChoice(i).getValue().equals(string)) continue;
            return this.getChoice(i);
        }
        return null;
    }

    public ItemsetBinding getDynamicChoices() {
        return this.dynamicChoices;
    }

    public void setDynamicChoices(ItemsetBinding itemsetBinding) {
        if (itemsetBinding != null) {
            itemsetBinding.setDestRef(this);
        }
        this.dynamicChoices = itemsetBinding;
    }

    public boolean isComplex() {
        return this.dynamicChoices != null && this.dynamicChoices.copyMode;
    }

    @Override
    public void localeChanged(String string, Localizer localizer) {
        if (this.choices != null) {
            for (int i = 0; i < this.choices.size(); ++i) {
                this.choices.elementAt(i).localeChanged(null, localizer);
            }
        }
        if (this.dynamicChoices != null) {
            this.dynamicChoices.localeChanged(string, localizer);
        }
        this.alertStateObservers(2);
    }

    @Override
    public Vector getChildren() {
        return null;
    }

    @Override
    public void setChildren(Vector vector) {
        throw new IllegalStateException();
    }

    @Override
    public void addChild(IFormElement iFormElement) {
        throw new IllegalStateException();
    }

    @Override
    public IFormElement getChild(int n) {
        return null;
    }

    @Override
    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.setID(ExtUtil.readInt(dataInputStream));
        this.binding = (IDataReference)ExtUtil.read(dataInputStream, new ExtWrapNullable(new ExtWrapTagged()), prototypeFactory);
        this.setAppearanceAttr((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setTextID((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setLabelInnerText((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setHelpText((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setHelpTextID((String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory));
        this.setControlType(ExtUtil.readInt(dataInputStream));
        this.choices = ExtUtil.nullIfEmpty((Vector)ExtUtil.read(dataInputStream, new ExtWrapList(SelectChoice.class), prototypeFactory));
        for (int i = 0; i < this.getNumChoices(); ++i) {
            this.choices.elementAt(i).setIndex(i);
        }
        this.setDynamicChoices((ItemsetBinding)ExtUtil.read(dataInputStream, new ExtWrapNullable(ItemsetBinding.class)));
    }

    @Override
    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.getID());
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.binding == null ? null : new ExtWrapTagged(this.binding)));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getAppearanceAttr()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getTextID()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getLabelInnerText()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getHelpText()));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.getHelpTextID()));
        ExtUtil.writeNumeric(dataOutputStream, this.getControlType());
        ExtUtil.write(dataOutputStream, new ExtWrapList(ExtUtil.emptyIfNull(this.choices)));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.dynamicChoices));
    }

    @Override
    public void registerStateObserver(FormElementStateListener formElementStateListener) {
        if (!this.observers.contains(formElementStateListener)) {
            this.observers.addElement(formElementStateListener);
        }
    }

    @Override
    public void unregisterStateObserver(FormElementStateListener formElementStateListener) {
        this.observers.removeElement(formElementStateListener);
    }

    public void unregisterAll() {
        this.observers.removeAllElements();
    }

    public void alertStateObservers(int n) {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((FormElementStateListener)enumeration.nextElement()).formElementStateChanged(this, n);
        }
    }

    @Override
    public int getDeepChildCount() {
        return 1;
    }

    public void setLabelInnerText(String string) {
        this.labelInnerText = string;
    }

    @Override
    public String getLabelInnerText() {
        return this.labelInnerText;
    }

    @Override
    public String getTextID() {
        return this.textID;
    }

    @Override
    public void setTextID(String string) {
        if (DateUtils.stringContains(string, ";")) {
            System.err.println("Warning: TextID contains ;form modifier:: \"" + string.substring(string.indexOf(";")) + "\"... will be stripped.");
            string = string.substring(0, string.indexOf(";"));
        }
        this.textID = string;
    }
}

