/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javarosa.core.model.condition.IFunctionHandler;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xpath.IExprDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationContext {
    private TreeReference contextNode;
    private Hashtable functionHandlers;
    private Hashtable variables;
    public boolean isConstraint;
    public IAnswerData candidateValue;
    public boolean isCheckAddChild;

    public EvaluationContext(EvaluationContext evaluationContext, TreeReference treeReference) {
        this.functionHandlers = evaluationContext.functionHandlers;
        this.contextNode = treeReference;
        this.variables = new Hashtable();
    }

    public EvaluationContext() {
        this.functionHandlers = new Hashtable();
        this.variables = new Hashtable();
    }

    public TreeReference getContextRef() {
        return this.contextNode;
    }

    public void addFunctionHandler(IFunctionHandler iFunctionHandler) {
        this.functionHandlers.put(iFunctionHandler.getName(), iFunctionHandler);
    }

    public Hashtable getFunctionHandlers() {
        return this.functionHandlers;
    }

    public void setVariables(Hashtable<String, ?> hashtable) {
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.setVariable(string, hashtable.get(string));
        }
    }

    public void setVariable(String string, Object object) {
        if (object == null) {
            this.variables.put(string, "");
            return;
        }
        if (object instanceof Boolean || object instanceof Double || object instanceof String || object instanceof Date || object instanceof IExprDataType) {
            this.variables.put(string, object);
            return;
        }
        if (object instanceof Integer) {
            this.variables.put(string, new Double(((Integer)object).doubleValue()));
            return;
        }
        if (object instanceof Float) {
            this.variables.put(string, new Double(((Float)object).doubleValue()));
            return;
        }
        this.variables.put(string, object);
    }

    public Object getVariable(String string) {
        return this.variables.get(string);
    }
}

