/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data.helper;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.javarosa.core.data.IDataPointer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class BasicDataPointer
implements IDataPointer {
    private byte[] data;
    private String name;

    public BasicDataPointer() {
    }

    public BasicDataPointer(String string, byte[] byArray) {
        this.name = string;
        this.data = byArray;
    }

    public boolean deleteData() {
        this.data = null;
        return true;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDisplayText() {
        return this.name;
    }

    public InputStream getDataStream() {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
        return byteArrayInputStream;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        int n = dataInputStream.readInt();
        if (n != -1) {
            this.data = new byte[n];
            dataInputStream.read(this.data);
        }
        this.name = ExtUtil.readString(dataInputStream);
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        if (this.data == null || this.data.length < 0) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(this.data.length);
            dataOutputStream.write(this.data);
        }
        ExtUtil.writeString(dataOutputStream, this.name);
    }

    public long getLength() {
        return this.data.length;
    }
}

