/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.instance;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.instance.utils.ITreeVisitor;
import org.javarosa.core.model.util.restorable.Restorable;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.model.utils.IInstanceVisitor;
import org.javarosa.core.services.storage.Persistable;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class FormInstance
implements Persistable,
Restorable {
    public static final String STORAGE_KEY = "FORMDATA";
    private TreeElement root = new TreeElement();
    private String name;
    private int id;
    private int formId;
    private Date dateSaved;
    public String schema;
    public String formVersion;
    public String uiVersion;
    private Hashtable namespaces = new Hashtable();

    public FormInstance() {
    }

    public FormInstance(TreeElement treeElement) {
        this.setID(-1);
        this.setFormId(-1);
        this.setRoot(treeElement);
    }

    public void setRoot(TreeElement treeElement) {
        this.root = new TreeElement();
        if (treeElement != null) {
            this.root.addChild(treeElement);
        }
    }

    public TreeElement getRoot() {
        if (this.root.getNumChildren() == 0) {
            throw new RuntimeException("root node has no children");
        }
        return this.root.getChildAt(0);
    }

    public static TreeReference unpackReference(IDataReference iDataReference) {
        return (TreeReference)iDataReference.getReference();
    }

    public TreeReference copyNode(TreeReference treeReference, TreeReference treeReference2) throws InvalidReferenceException {
        if (!treeReference.isAbsolute()) {
            throw new InvalidReferenceException("Source reference must be absolute for copying", treeReference);
        }
        TreeElement treeElement = this.resolveReference(treeReference);
        if (treeElement == null) {
            throw new InvalidReferenceException("Null Source reference while attempting to copy node", treeReference);
        }
        return this.copyNode(treeElement, treeReference2).getRef();
    }

    public TreeElement copyNode(TreeElement treeElement, TreeReference treeReference) throws InvalidReferenceException {
        if (!treeReference.isAbsolute()) {
            throw new InvalidReferenceException("Destination reference must be absolute for copying", treeReference);
        }
        String string = treeReference.getNameLast();
        int n = treeReference.getMultLast();
        TreeReference treeReference2 = treeReference.getParentRef();
        TreeElement treeElement2 = this.resolveReference(treeReference2);
        if (treeElement2 == null) {
            throw new InvalidReferenceException("Null parent reference whle attempting to copy", treeReference2);
        }
        if (!treeElement2.isChildable()) {
            throw new InvalidReferenceException("Invalid Parent Node: cannot accept children.", treeReference2);
        }
        if (n == -1) {
            n = treeElement2.getChildMultiplicity(string);
        } else if (treeElement2.getChild(string, n) != null) {
            throw new InvalidReferenceException("Destination already exists!", treeReference);
        }
        TreeElement treeElement3 = treeElement.deepCopy(false);
        treeElement3.setName(string);
        treeElement3.multiplicity = n;
        treeElement2.addChild(treeElement3);
        return treeElement3;
    }

    public void copyItemsetNode(TreeElement treeElement, TreeReference treeReference, FormDef formDef) throws InvalidReferenceException {
        TreeElement treeElement2 = this.getTemplate(treeReference);
        TreeElement treeElement3 = this.copyNode(treeElement2, treeReference);
        treeElement3.populateTemplate(treeElement, formDef);
    }

    public IAnswerData getDataValue(IDataReference iDataReference) {
        TreeElement treeElement = this.resolveReference(iDataReference);
        if (treeElement != null) {
            return treeElement.getValue();
        }
        return null;
    }

    public TreeElement resolveReference(TreeReference treeReference) {
        if (!treeReference.isAbsolute()) {
            return null;
        }
        TreeElement treeElement = this.root;
        for (int i = 0; i < treeReference.size(); ++i) {
            String string = treeReference.getName(i);
            int n = treeReference.getMultiplicity(i);
            if (n == -4) {
                treeElement = treeElement.getAttribute(null, string);
                continue;
            }
            if (n == -1) {
                if (treeElement.getChildMultiplicity(string) == 1) {
                    n = 0;
                } else {
                    treeElement = null;
                    break;
                }
            }
            if ((treeElement = treeElement.getChild(string, n)) == null) break;
        }
        return treeElement == this.root ? null : treeElement;
    }

    public Vector explodeReference(TreeReference treeReference) {
        if (!treeReference.isAbsolute()) {
            return null;
        }
        Vector<TreeElement> vector = new Vector<TreeElement>();
        TreeElement treeElement = this.root;
        for (int i = 0; i < treeReference.size(); ++i) {
            String string = treeReference.getName(i);
            int n = treeReference.getMultiplicity(i);
            if (n == -4) {
                if (treeElement != this.root) {
                    vector.addElement(treeElement);
                }
                treeElement = treeElement.getAttribute(null, string);
                continue;
            }
            if (n == -1) {
                if (treeElement.getChildMultiplicity(string) == 1) {
                    n = 0;
                } else {
                    return null;
                }
            }
            if (treeElement != this.root) {
                vector.addElement(treeElement);
            }
            if ((treeElement = treeElement.getChild(string, n)) != null) continue;
            return null;
        }
        return vector;
    }

    public Vector expandReference(TreeReference treeReference) {
        return this.expandReference(treeReference, false);
    }

    public Vector expandReference(TreeReference treeReference, boolean bl) {
        if (!treeReference.isAbsolute()) {
            return null;
        }
        Vector vector = new Vector();
        this.expandReference(treeReference, this.root, vector, bl);
        return vector;
    }

    private void expandReference(TreeReference treeReference, TreeElement treeElement, Vector vector, boolean bl) {
        int n = treeElement.getDepth();
        if (n == treeReference.size()) {
            vector.addElement(treeElement.getRef());
        } else {
            String string = treeReference.getName(n);
            int n2 = treeReference.getMultiplicity(n);
            Vector<TreeElement> vector2 = new Vector<TreeElement>();
            if (treeElement.getNumChildren() > 0) {
                TreeElement treeElement2;
                if (n2 == -1) {
                    TreeElement treeElement3;
                    int n3 = treeElement.getChildMultiplicity(string);
                    for (int i = 0; i < n3; ++i) {
                        TreeElement treeElement4 = treeElement.getChild(string, i);
                        if (treeElement4 == null) {
                            throw new IllegalStateException();
                        }
                        vector2.addElement(treeElement4);
                    }
                    if (bl && (treeElement3 = treeElement.getChild(string, -2)) != null) {
                        vector2.addElement(treeElement3);
                    }
                } else if (n2 != -4 && (treeElement2 = treeElement.getChild(string, n2)) != null) {
                    vector2.addElement(treeElement2);
                }
            }
            if (n2 == -4) {
                TreeElement treeElement5 = treeElement.getAttribute(null, string);
                vector2.addElement(treeElement5);
            }
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                this.expandReference(treeReference, (TreeElement)enumeration.nextElement(), vector, bl);
            }
        }
    }

    public TreeElement getTemplate(TreeReference treeReference) {
        TreeElement treeElement = this.getTemplatePath(treeReference);
        return treeElement == null ? null : (treeElement.repeatable ? treeElement : null);
    }

    public TreeElement getTemplatePath(TreeReference treeReference) {
        if (!treeReference.isAbsolute()) {
            return null;
        }
        TreeElement treeElement = this.root;
        for (int i = 0; i < treeReference.size(); ++i) {
            String string = treeReference.getName(i);
            if (treeReference.getMultiplicity(i) == -4) {
                treeElement = treeElement.getAttribute(null, string);
                continue;
            }
            TreeElement treeElement2 = treeElement.getChild(string, -2);
            if (treeElement2 == null) {
                treeElement2 = treeElement.getChild(string, 0);
            }
            if (treeElement2 == null) {
                return null;
            }
            treeElement = treeElement2;
        }
        return treeElement;
    }

    public static boolean isHomogeneous(TreeElement treeElement, TreeElement treeElement2) {
        if (treeElement.isLeaf() && treeElement2.isLeaf()) {
            return true;
        }
        if (treeElement.isChildable() && treeElement2.isChildable()) {
            TreeElement treeElement3;
            TreeElement treeElement4;
            int n;
            for (n = 0; n < 2; ++n) {
                treeElement4 = n == 0 ? treeElement : treeElement2;
                treeElement3 = n == 0 ? treeElement2 : treeElement;
                for (int i = 0; i < treeElement4.getNumChildren(); ++i) {
                    TreeElement treeElement5 = treeElement4.getChildAt(i);
                    if (treeElement5.repeatable) continue;
                    TreeElement treeElement6 = treeElement3.getChild(treeElement5.getName(), 0);
                    if (treeElement6 == null) {
                        return false;
                    }
                    if (!treeElement6.repeatable) continue;
                    throw new RuntimeException("shouldn't happen");
                }
            }
            for (n = 0; n < treeElement.getNumChildren(); ++n) {
                treeElement4 = treeElement.getChildAt(n);
                if (treeElement4.repeatable || FormInstance.isHomogeneous(treeElement4, treeElement3 = treeElement2.getChild(treeElement4.getName(), 0))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TreeElement resolveReference(IDataReference iDataReference) {
        return this.resolveReference(FormInstance.unpackReference(iDataReference));
    }

    public void accept(IInstanceVisitor iInstanceVisitor) {
        iInstanceVisitor.visit(this);
        if (iInstanceVisitor instanceof ITreeVisitor) {
            this.root.accept((ITreeVisitor)iInstanceVisitor);
        }
    }

    public void setDateSaved(Date date) {
        this.dateSaved = date;
    }

    public void setFormId(int n) {
        this.formId = n;
    }

    public Date getDateSaved() {
        return this.dateSaved;
    }

    public int getFormId() {
        return this.formId;
    }

    public void readExternal(DataInputStream dataInputStream, PrototypeFactory prototypeFactory) throws IOException, DeserializationException {
        this.id = ExtUtil.readInt(dataInputStream);
        this.formId = ExtUtil.readInt(dataInputStream);
        this.name = (String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory);
        this.schema = (String)ExtUtil.read(dataInputStream, new ExtWrapNullable(String.class), prototypeFactory);
        this.dateSaved = (Date)ExtUtil.read(dataInputStream, new ExtWrapNullable(Date.class), prototypeFactory);
        this.namespaces = (Hashtable)ExtUtil.read(dataInputStream, new ExtWrapMap(String.class, String.class));
        this.setRoot((TreeElement)ExtUtil.read(dataInputStream, TreeElement.class, prototypeFactory));
    }

    public void writeExternal(DataOutputStream dataOutputStream) throws IOException {
        ExtUtil.writeNumeric(dataOutputStream, this.id);
        ExtUtil.writeNumeric(dataOutputStream, this.formId);
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.name));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.schema));
        ExtUtil.write(dataOutputStream, new ExtWrapNullable(this.dateSaved));
        ExtUtil.write(dataOutputStream, new ExtWrapMap(this.namespaces));
        ExtUtil.write(dataOutputStream, this.getRoot());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public TreeReference addNode(TreeReference treeReference) {
        TreeReference treeReference2 = treeReference.clone();
        if (this.createNode(treeReference2) != null) {
            return treeReference2;
        }
        return null;
    }

    public TreeReference addNode(TreeReference treeReference, IAnswerData iAnswerData, int n) {
        TreeReference treeReference2 = treeReference.clone();
        TreeElement treeElement = this.createNode(treeReference2);
        if (treeElement != null) {
            if (n >= 0) {
                treeElement.dataType = n;
            }
            treeElement.setValue(iAnswerData);
            return treeReference2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TreeElement createNode(TreeReference treeReference) {
        TreeElement treeElement = this.root;
        for (int i = 0; i < treeReference.size(); ++i) {
            TreeElement treeElement2;
            String string = treeReference.getName(i);
            int n = treeElement.getChildMultiplicity(string);
            int n2 = treeReference.getMultiplicity(i);
            if (i < treeReference.size() - 1) {
                if (n2 == -1) {
                    if (n > 1) {
                        return null;
                    }
                    n2 = 0;
                    treeReference.setMultiplicity(i, 0);
                }
                if ((treeElement2 = treeElement.getChild(string, n2)) == null) {
                    if (n2 != 0) return null;
                    treeElement2 = new TreeElement(string, n);
                    treeElement.addChild(treeElement2);
                    treeReference.setMultiplicity(i, n);
                }
            } else {
                if (n2 != -1 && n2 != n) return null;
                if (i == 0 && this.root.getNumChildren() != 0) {
                    return null;
                }
                if (!treeElement.isChildable()) {
                    return null;
                }
                treeElement2 = new TreeElement(string, n);
                treeElement.addChild(treeElement2);
                treeReference.setMultiplicity(i, n);
            }
            treeElement = treeElement2;
        }
        return treeElement;
    }

    public void addNamespace(String string, String string2) {
        this.namespaces.put(string, string2);
    }

    public String[] getNamespacePrefixes() {
        String[] stringArray = new String[this.namespaces.size()];
        int n = 0;
        Enumeration enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String getNamespaceURI(String string) {
        return (String)this.namespaces.get(string);
    }

    public String getRestorableType() {
        return "form";
    }

    public FormInstance exportData() {
        FormInstance formInstance = RestoreUtils.createDataModel(this);
        RestoreUtils.addData(formInstance, "name", this.name);
        RestoreUtils.addData(formInstance, "form-id", new Integer(this.formId));
        RestoreUtils.addData(formInstance, "saved-on", this.dateSaved, 6);
        RestoreUtils.addData(formInstance, "schema", this.schema);
        throw new RuntimeException("FormInstance.exportData(): must be updated to use new transport layer");
    }

    public void templateData(FormInstance formInstance, TreeReference treeReference) {
        RestoreUtils.applyDataType(formInstance, "name", treeReference, String.class);
        RestoreUtils.applyDataType(formInstance, "form-id", treeReference, Integer.class);
        RestoreUtils.applyDataType(formInstance, "saved-on", treeReference, 6);
        RestoreUtils.applyDataType(formInstance, "schema", treeReference, String.class);
        RestoreUtils.applyDataType(formInstance, "sent", treeReference, Boolean.class);
    }

    public void importData(FormInstance formInstance) {
        this.name = (String)RestoreUtils.getValue("name", formInstance);
        this.formId = (Integer)RestoreUtils.getValue("form-id", formInstance);
        this.dateSaved = (Date)RestoreUtils.getValue("saved-on", formInstance);
        this.schema = (String)RestoreUtils.getValue("schema", formInstance);
        boolean bl = RestoreUtils.getBoolean(RestoreUtils.getValue("sent", formInstance));
        TreeElement treeElement = formInstance.resolveReference(RestoreUtils.absRef("namespace", formInstance));
        if (treeElement != null) {
            for (int i = 0; i < treeElement.getNumChildren(); ++i) {
                TreeElement treeElement2 = treeElement.getChildAt(i);
                String string = treeElement2.getName();
                Object object = RestoreUtils.getValue("namespace/" + string, formInstance);
                if (object == null) continue;
                this.namespaces.put(string, object);
            }
        }
        throw new RuntimeException("FormInstance.importData(): must be updated to use new transport layer");
    }

    public TreeElement processSaved(FormInstance formInstance, FormDef formDef) {
        TreeElement treeElement = formInstance.getRoot().deepCopy(true);
        TreeElement treeElement2 = this.root.getChildAt(0);
        if (!treeElement.getName().equals(treeElement2.getName()) || treeElement2.getMult() != 0) {
            throw new RuntimeException("Saved form instance to restore does not match form definition");
        }
        treeElement.populate(treeElement2, formDef);
        return treeElement;
    }

    public FormInstance clone() {
        FormInstance formInstance = new FormInstance(this.getRoot().deepCopy(true));
        formInstance.setID(this.getID());
        formInstance.setFormId(this.getFormId());
        formInstance.setName(this.getName());
        formInstance.setDateSaved(this.getDateSaved());
        formInstance.schema = this.schema;
        formInstance.formVersion = this.formVersion;
        formInstance.uiVersion = this.uiVersion;
        formInstance.namespaces = new Hashtable();
        Enumeration enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            formInstance.namespaces.put(k, this.namespaces.get(k));
        }
        return formInstance;
    }
}

